/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIExperienceSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UIExperienceSection.msg.confirmDeleteExp", phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormCheckBoxInput.class, id="UIFormCheckBoxEndDate", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ShowHideEndDateActionListener.class})})})
public class UIExperienceSection
extends UIProfileSection {
    public static final String START_DATE_AFTER_TODAY = "UIExperienceSection.msg.StartDateAfterToday";
    public static final String END_DATE_AFTER_TODAY = "UIExperienceSection.msg.EndDateAfterToday";
    public static final String STARTDATE_BEFORE_ENDDATE = "UIExperienceSection.msg.startDateBeforeEndDate";
    public static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    int expIdx = 0;

    public final int getExpCount() {
        return this.expIdx;
    }

    public final List<UIComponent> getChilds() {
        return this.getChildren();
    }

    public UIExperienceSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
    }

    public final int getMonth(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(2) + 1;
    }

    public final int getDate(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(5);
    }

    public final int getYear(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(1);
    }

    public final List<HashMap<String, Object>> getPastExperience() throws Exception {
        ArrayList<HashMap<String, Object>> pastExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile(true);
        ArrayList experiences = (ArrayList)p.getProperty("experiences");
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (((Boolean)map.get("isCurrent")).booleanValue()) continue;
                pastExperiences.add(map);
            }
        }
        return pastExperiences;
    }

    public final List<HashMap<String, Object>> getCurrentExperience() throws Exception {
        ArrayList<HashMap<String, Object>> currentExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile(true);
        ArrayList experiences = (ArrayList)p.getProperty("experiences");
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (!((Boolean)map.get("isCurrent")).booleanValue()) continue;
                currentExperiences.add(map);
            }
        }
        return currentExperiences;
    }

    private int saveProfileInfo() throws Exception {
        ArrayList experiences = new ArrayList();
        UIFormStringInput uiStringInput = null;
        UIFormTextAreaInput uiFormTextAreaInput = null;
        UIFormCheckBoxInput uiCheckBox = null;
        UIFormDateTimeInput uiDateTimeInput = null;
        String company = null;
        String position = null;
        String description = null;
        String skills = null;
        String startDate = null;
        String endDate = null;
        Boolean isCurrent = null;
        Date sDate = null;
        Date eDate = null;
        Date today = new Date();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApplication = context.getUIApplication();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Profile p = this.getProfile(true);
        List<UIComponent> listUIComp = this.getChilds();
        int totalUIComponent = listUIComp.size() - 1;
        if (totalUIComponent == 0) {
            if (p != null) {
                Profile updateProfile = new Profile(p.getIdentity());
                updateProfile.setId(p.getId());
                updateProfile.setProperty("experiences", experiences);
                im.updateExperienceSection(updateProfile);
            }
            return 0;
        }
        for (int i = 1; i <= totalUIComponent; i += 7) {
            HashMap<String, Object> uiMap = new HashMap<String, Object>();
            uiStringInput = (UIFormStringInput)listUIComp.get(i);
            company = (String)uiStringInput.getValue();
            uiStringInput = (UIFormStringInput)listUIComp.get(i + 1);
            position = (String)uiStringInput.getValue();
            uiFormTextAreaInput = (UIFormTextAreaInput)listUIComp.get(i + 2);
            description = (String)uiFormTextAreaInput.getValue();
            uiFormTextAreaInput = (UIFormTextAreaInput)listUIComp.get(i + 3);
            skills = (String)uiFormTextAreaInput.getValue();
            uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 4);
            startDate = (String)uiDateTimeInput.getValue();
            uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 5);
            endDate = (String)uiDateTimeInput.getValue();
            sDate = this.stringToDate(startDate);
            eDate = this.stringToDate(endDate);
            if (sDate.after(today)) {
                uiApplication.addMessage(new ApplicationMessage(START_DATE_AFTER_TODAY, null));
                return 2;
            }
            uiCheckBox = (UIFormCheckBoxInput)listUIComp.get(i + 6);
            isCurrent = (Boolean)uiCheckBox.getValue();
            if (!isCurrent.booleanValue()) {
                if (eDate.after(today)) {
                    uiApplication.addMessage(new ApplicationMessage(END_DATE_AFTER_TODAY, null));
                    return 2;
                }
                if (sDate.after(eDate)) {
                    uiApplication.addMessage(new ApplicationMessage(STARTDATE_BEFORE_ENDDATE, null));
                    return 1;
                }
            } else {
                endDate = null;
            }
            uiMap.put("company", this.escapeHtml(company));
            uiMap.put("position", this.escapeHtml(position));
            uiMap.put("description", this.escapeHtml(description));
            uiMap.put("skills", this.escapeHtml(skills));
            uiMap.put("startDate", startDate);
            uiMap.put("endDate", endDate);
            uiMap.put("isCurrent", isCurrent);
            experiences.add(uiMap);
        }
        Profile updateProfile = new Profile(p.getIdentity());
        updateProfile.setId(p.getId());
        updateProfile.setProperty("experiences", experiences);
        im.updateExperienceSection(updateProfile);
        return 0;
    }

    private void addUIFormInput() throws Exception {
        ++this.expIdx;
        this.addUIFormInput((UIFormInput)new UIFormStringInput("company" + this.expIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 90}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("position" + this.expIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 90}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput("description" + this.expIdx, null, null));
        UIFormTextAreaInput uiDespcription = (UIFormTextAreaInput)this.getChildById("description" + this.expIdx);
        uiDespcription.setColumns(28);
        uiDespcription.setRows(3);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput("skills" + this.expIdx, null, null));
        UIFormTextAreaInput uiFormTextAreaInput = (UIFormTextAreaInput)this.getChildById("skills" + this.expIdx);
        uiFormTextAreaInput.setColumns(28);
        uiFormTextAreaInput.setRows(3);
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput("startDate" + this.expIdx, null, null, false).addValidator(DateTimeValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput("endDate" + this.expIdx, null, null, false).addValidator(MandatoryValidator.class, new Object[0]).addValidator(DateTimeValidator.class, new Object[0]));
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(Integer.toString(this.expIdx), null, (Object)false);
        uiDateInputCheck.setComponentConfig(UIFormCheckBoxInput.class, "UIFormCheckBoxEndDate");
        uiDateInputCheck.setOnChange("ShowHideEndDate", uiDateInputCheck.getId());
        this.addUIFormInput((UIFormInput)uiDateInputCheck);
    }

    private Date stringToDate(String dateStr) throws ParseException {
        SimpleDateFormat formatDate = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY);
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        return formatDate.parse(dateStr);
    }

    private Calendar getCalendar(String inDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY);
        Date date = format.parse(inDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowHideEndDateActionListener
    extends EventListener<UIFormCheckBoxInput<Boolean>> {
        public final void execute(Event<UIFormCheckBoxInput<Boolean>> event) throws Exception {
            UIFormCheckBoxInput sect = (UIFormCheckBoxInput)event.getSource();
            UIExperienceSection uiForm = (UIExperienceSection)sect.getAncestorOfType(UIExperienceSection.class);
            UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)uiForm.getChildById("endDate" + sect.getId());
            boolean isCheck = sect.isChecked();
            uiDateTime.setRendered(!isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public final void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIExperienceSection uiExpSection = (UIExperienceSection)sect;
            Profile p = sect.getProfile(true);
            List<UIComponent> listChild = uiExpSection.getChilds();
            ArrayList listProfile = new ArrayList();
            int childSize = listChild.size() - 1;
            String companyId = null;
            String positionId = null;
            String skillsId = null;
            String startDateId = null;
            String isCurrentId = null;
            String endDateId = null;
            String descriptionId = null;
            ArrayList experiences = (ArrayList)p.getProperty("experiences");
            if (experiences == null) {
                for (int idx = 1; idx <= childSize; idx += 7) {
                    sect.removeChild(UIFormStringInput.class);
                    sect.removeChild(UIFormStringInput.class);
                    sect.removeChild(UIFormTextAreaInput.class);
                    sect.removeChild(UIFormTextAreaInput.class);
                    sect.removeChild(UIFormDateTimeInput.class);
                    sect.removeChild(UIFormDateTimeInput.class);
                    sect.removeChild(UIFormCheckBoxInput.class);
                }
            } else {
                for (HashMap map : experiences) {
                    listProfile.add(map.get("company"));
                    listProfile.add(map.get("position"));
                    listProfile.add(map.get("description"));
                    listProfile.add(map.get("skills"));
                    listProfile.add(map.get("startDate"));
                    listProfile.add(map.get("endDate"));
                    listProfile.add(map.get("isCurrent"));
                }
                int totalProfiles = listProfile.size();
                int numberOfChildren = 0;
                if (totalProfiles > childSize) {
                    for (numberOfChildren = childSize; totalProfiles > numberOfChildren; numberOfChildren += 7) {
                        uiExpSection.addUIFormInput();
                    }
                } else if (totalProfiles < childSize) {
                    for (numberOfChildren = childSize; totalProfiles < numberOfChildren; numberOfChildren -= 7) {
                        companyId = listChild.get(childSize - 6).getName();
                        positionId = listChild.get(childSize - 5).getName();
                        descriptionId = listChild.get(childSize - 4).getName();
                        skillsId = listChild.get(childSize - 3).getName();
                        startDateId = listChild.get(childSize - 2).getName();
                        endDateId = listChild.get(childSize - 1).getName();
                        isCurrentId = listChild.get(childSize).getName();
                        sect.removeChildById(companyId);
                        sect.removeChildById(positionId);
                        sect.removeChildById(descriptionId);
                        sect.removeChildById(skillsId);
                        sect.removeChildById(startDateId);
                        sect.removeChildById(endDateId);
                        sect.removeChildById(isCurrentId);
                    }
                }
                List<UIComponent> listChildForSetValue = uiExpSection.getChilds();
                for (int idx = 0; idx < totalProfiles; idx += 7) {
                    ((UIFormInput)listChildForSetValue.get(idx + 1)).setValue(listProfile.get(idx));
                    ((UIFormInput)listChildForSetValue.get(idx + 2)).setValue(listProfile.get(idx + 1));
                    ((UIFormInput)listChildForSetValue.get(idx + 3)).setValue(listProfile.get(idx + 2));
                    ((UIFormInput)listChildForSetValue.get(idx + 4)).setValue(listProfile.get(idx + 3));
                    ((UIFormInput)listChildForSetValue.get(idx + 5)).setValue(listProfile.get(idx + 4));
                    ((UIFormInput)listChildForSetValue.get(idx + 6)).setValue(listProfile.get(idx + 5));
                    ((UIFormCheckBoxInput)listChildForSetValue.get(idx + 7)).setValue((Object)((Boolean)listProfile.get(idx + 6)));
                    ((UIFormDateTimeInput)listChildForSetValue.get(idx + 6)).setRendered((Boolean)((UIFormCheckBoxInput)listChildForSetValue.get(idx + 7)).getValue() == false);
                }
            }
            super.execute(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public final void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIExperienceSection uiExperienceSectionSect = (UIExperienceSection)sect;
            if (uiExperienceSectionSect.saveProfileInfo() == 0) {
                super.execute(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIExperienceSection> {
        public final void execute(Event<UIExperienceSection> event) throws Exception {
            UIExperienceSection uiForm = (UIExperienceSection)((Object)event.getSource());
            String block = event.getRequestContext().getRequestParameter("objectId");
            int blockIdx = Integer.parseInt(block);
            String companyId = null;
            String positionId = null;
            String descriptionId = null;
            String skillsId = null;
            String startDateId = null;
            String endDateId = null;
            String isCurrentId = null;
            List<UIComponent> listChild = uiForm.getChilds();
            companyId = listChild.get(blockIdx).getId();
            positionId = listChild.get(blockIdx + 1).getId();
            descriptionId = listChild.get(blockIdx + 2).getId();
            skillsId = listChild.get(blockIdx + 3).getId();
            startDateId = listChild.get(blockIdx + 4).getId();
            endDateId = listChild.get(blockIdx + 5).getId();
            isCurrentId = listChild.get(blockIdx + 6).getId();
            uiForm.removeChildById(companyId);
            uiForm.removeChildById(positionId);
            uiForm.removeChildById(descriptionId);
            uiForm.removeChildById(skillsId);
            uiForm.removeChildById(startDateId);
            uiForm.removeChildById(endDateId);
            uiForm.removeChildById(isCurrentId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIExperienceSection> {
        public final void execute(Event<UIExperienceSection> event) throws Exception {
            UIExperienceSection uiForm = (UIExperienceSection)((Object)event.getSource());
            uiForm.addUIFormInput();
        }
    }
}

