/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.page.UIPageNodeForm;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceNavigationManagement.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})}), @ComponentConfig(type=UIPageNodeForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm.SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.CreatePageActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, id="AddNode", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup")})})
public class UISpaceNavigationManagement
extends UIContainer {
    private String owner;
    private String ownerType;

    public UISpaceNavigationManagement() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, "AddNode", null);
        uiPopup.setWindowSize(800, 500);
        uiPopup.setShow(false);
        this.addChild((UIComponent)uiPopup);
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        String spaceUrl = SpaceUtils.getSpaceUrl();
        Space space = spaceService.getSpaceByUrl(spaceUrl);
        PageNavigation groupNav = SpaceUtils.getGroupNavigation((String)space.getGroupId());
        this.setOwner(groupNav.getOwnerId());
        this.setOwnerType(groupNav.getOwnerType());
        UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)this.createUIComponent(UISpaceNavigationNodeSelector.class, null, "UISpaceNavigationNodeSelector");
        selector.setEdittedNavigation(groupNav);
        selector.initTreeData();
        this.addChild((UIComponent)selector);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return "/spaces/" + SpaceUtils.getSpaceUrl();
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        return (T)super.setRendered(b);
    }

    public void loadView(Event<? extends UIComponent> event) throws Exception {
        UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)this.getChild(UISpaceNavigationNodeSelector.class);
        UITree uiTree = (UITree)uiNodeSelector.getChild(UITree.class);
        uiTree.createEvent("ChangeNode", event.getExecutionPhase(), event.getRequestContext()).broadcast();
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClosePopupActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)event.getSource();
            UISpaceNavigationManagement uiSpaceNavManagement = (UISpaceNavigationManagement)uiPopup.getAncestorOfType(UISpaceNavigationManagement.class);
            UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)uiSpaceNavManagement.getChild(UISpaceNavigationNodeSelector.class);
            PageNavigation contextNavigation = selector.getEdittedNavigation();
            uiPopup.setShow(false);
            uiSpaceNavManagement.setOwner(contextNavigation.getOwnerId());
            uiSpaceNavManagement.setOwnerType(contextNavigation.getOwnerType());
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceNavManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNode = (UIPageNodeForm)event.getSource();
            PageNavigation contextNavigation = uiPageNode.getContextPageNavigation();
            UISpaceNavigationManagement uiSpaceNavManagement = (UISpaceNavigationManagement)uiPageNode.getAncestorOfType(UISpaceNavigationManagement.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceNavManagement.getChild(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiSpaceNavManagement.setOwner(contextNavigation.getOwnerId());
            uiSpaceNavManagement.setOwnerType(contextNavigation.getOwnerType());
            UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)uiSpaceNavManagement.getChild(UISpaceNavigationNodeSelector.class);
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceNavManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UISpaceNavigationManagement> {
        public void execute(Event<UISpaceNavigationManagement> event) throws Exception {
            UISpaceNavigationManagement uiManagement = (UISpaceNavigationManagement)((Object)event.getSource());
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiManagement.getChild(UISpaceNavigationNodeSelector.class);
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
            UIPageNodeForm uiNodeForm = (UIPageNodeForm)uiManagementPopup.createUIComponent(UIPageNodeForm.class, null, null);
            uiNodeForm.setValues(null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            PageNavigation nav = uiNodeSelector.getEdittedNavigation();
            uiNodeForm.setSelectedParent((Object)nav);
            uiNodeForm.setContextPageNavigation(nav);
            uiManagementPopup.setWindowSize(800, 500);
            uiManagementPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagementPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISpaceNavigationManagement> {
        /*
         * Enabled aggressive block sorting
         */
        public void execute(Event<UISpaceNavigationManagement> event) throws Exception {
            String editedOwnerId;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UISpaceNavigationManagement uiManagement = (UISpaceNavigationManagement)((Object)event.getSource());
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiManagement.getChild(UISpaceNavigationNodeSelector.class);
            DataStorage dataService = (DataStorage)uiManagement.getApplicationComponent(DataStorage.class);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            PageNavigation navigation = uiNodeSelector.getEdittedNavigation();
            String editedOwnerType = navigation.getOwnerType();
            PageNavigation persistNavigation = dataService.getPageNavigation(editedOwnerType, editedOwnerId = navigation.getOwnerId());
            if (persistNavigation == null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UISpaceNavigationManagement.msg.NavigationNotExistAnymore", null));
                UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
                uiPopup.setShow(false);
                UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                prContext.setFullRender(true);
                return;
            }
            if ("portal".equals(navigation.getOwnerType())) {
                UserPortalConfig portalConfig = portalConfigService.getUserPortalConfig(navigation.getOwnerId(), prContext.getRemoteUser());
                if (portalConfig == null) {
                    UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                    uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null));
                    UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
                    uiPopup.setShow(false);
                    UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                    prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                    prContext.setFullRender(true);
                    return;
                }
                dataService.save(navigation);
            } else {
                dataService.save(navigation);
            }
            navigation = dataService.getPageNavigation(navigation.getOwnerType(), navigation.getOwnerId());
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            this.setNavigation(uiPortalApp.getNavigations(), navigation);
            uiPortalApp.localizeNavigations();
            UIPortal targetedUIPortal = uiPortalApp.getCachedUIPortal(editedOwnerType, editedOwnerId);
            if (targetedUIPortal != null) {
                targetedUIPortal.setNavigation(navigation);
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
            uiPopup.setShow(false);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
        }

        private void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
            for (int i = 0; i < navs.size(); ++i) {
                if (navs.get(i).getId() != nav.getId()) continue;
                navs.set(i, nav);
                return;
            }
        }
    }
}

