/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManagePublicSpaces.gtmpl", events={@EventConfig(listeners={RequestJoinActionListener.class})})
public class UIManagePublicSpaces
extends UIContainer {
    private static final String SPACE_DELETED_INFO = "UIPublicSpacePortlet.msg.DeletedInfo";
    private static final String MSG_ERROR_REQUEST_JOIN = "UIManagePublicSpaces.msg.error_request_join";
    private static final int FIRST_PAGE = 1;
    private SpaceService spaceService = null;
    private String userId = null;
    private UIPageIterator iterator;
    private final String ITERATOR_ID = "UIIteratorPublicSpaces";
    private final Integer SPACES_PER_PAGE = 4;
    private static final String PUBLIC_STATUS = "public";
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    public static final String SEARCH_ALL = "All";

    public UIManagePublicSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(PUBLIC_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPublicSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllPublicSpaces() throws Exception {
        UserACL userACL;
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        if (userId.equals((userACL = (UserACL)this.getApplicationComponent(UserACL.class)).getSuperUser())) {
            return new ArrayList<Space>();
        }
        return spaceService.getPublicSpaces(userId);
    }

    public boolean hasEditPermission(Space space) throws Exception {
        return this.spaceService.hasSettingPermission(space, this.getUserId());
    }

    public List<Space> getPublicSpaces() throws Exception {
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getPublicSpaceNames());
        return this.getDisplayPublicSpaces(this.iterator);
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private List<String> getPublicSpaceNames() throws Exception {
        List<Space> publicSpaces = this.getAllPublicSpaces();
        ArrayList<String> publicSpaceNames = new ArrayList<String>();
        for (Space space : publicSpaces) {
            publicSpaceNames.add(space.getDisplayName());
        }
        return publicSpaceNames;
    }

    private List<Space> getDisplayPublicSpaces(UIPageIterator iterator) throws Exception {
        LazyPageList pageList = null;
        int currentPage = iterator.getCurrentPage();
        String charSearch = this.uiSpaceSearch.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        if (charSearch == null && searchCondition == null || charSearch != null && charSearch.equals(SEARCH_ALL)) {
            pageList = new LazyPageList(this.spaceService.getPublicSpacesWithListAccess(this.userId), this.SPACES_PER_PAGE.intValue());
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = charSearch != null ? new SpaceFilter(charSearch.charAt(0)) : new SpaceFilter(searchCondition);
            pageList = new LazyPageList(this.spaceService.getPublicSpacesByFilter(this.userId, spaceFilter), this.SPACES_PER_PAGE.intValue());
        }
        iterator.setPageList((PageList)pageList);
        int availablePage = iterator.getAvailablePage();
        if (this.uiSpaceSearch.isNewSearch()) {
            iterator.setCurrentPage(1);
        } else if (currentPage > availablePage) {
            iterator.setCurrentPage(availablePage);
        } else {
            iterator.setCurrentPage(currentPage);
        }
        this.uiSpaceSearch.setNewSearch(false);
        return iterator.getCurrentPageData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestJoinActionListener
    extends EventListener<UIManagePublicSpaces> {
        public void execute(Event<UIManagePublicSpaces> event) throws Exception {
            UIManagePublicSpaces uiPublicSpaces = (UIManagePublicSpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            SpaceService spaceService = uiPublicSpaces.getSpaceService();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiPublicSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManagePublicSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            spaceService.addPendingUser(space, userId);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("SpacesToolbarPortlet");
            uiWorkingWS.updatePortletsByName("SocialUserToolBarGroupPortlet");
        }
    }
}

