/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIInvitations.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIInvitations
extends UIContainer {
    private static final String iteratorIDInvitation = "UIPageIteratorInvitation";
    private static final String INVITATION_REVOKED_INFO = "UIInvitations.label.RevokedInfo";
    private static final String INCOMING_STATUS = "incoming";
    private UIPageIterator uiPageIteratorInvitation = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorInvitation");
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;
    private static final int FIRST_PAGE = 1;
    private static final int RELATIONSHIP_PER_PAGE = 5;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIteratorInvitation() {
        return this.uiPageIteratorInvitation;
    }

    public UIInvitations() throws Exception {
        this.addChild((UIComponent)this.uiPageIteratorInvitation);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchRelation.setTypeOfRelation(INCOMING_STATUS);
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
        this.identityList = new ArrayList<Identity>();
    }

    public List<Identity> getInvitation() throws Exception {
        int curPage = this.uiPageIteratorInvitation.getCurrentPage();
        ListAccess incomingListAccess = Utils.getRelationshipManager().getIncomingWithListAccess(Utils.getOwnerIdentity());
        if (incomingListAccess != null && incomingListAccess.getSize() == 0) {
            return new ArrayList<Identity>();
        }
        LazyPageList pageListContact = new LazyPageList(incomingListAccess, 5);
        this.uiPageIteratorInvitation.setPageList((PageList)pageListContact);
        int availablePage = this.uiPageIteratorInvitation.getAvailablePage();
        if (this.uiProfileUserSearchRelation.isNewSearch()) {
            this.uiPageIteratorInvitation.setCurrentPage(1);
        } else if (curPage > availablePage) {
            this.uiPageIteratorInvitation.setCurrentPage(availablePage);
        } else {
            this.uiPageIteratorInvitation.setCurrentPage(curPage);
        }
        this.uiProfileUserSearchRelation.setNewSearch(false);
        return this.uiPageIteratorInvitation.getCurrentPageData();
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiMyRelation = (UIInvitations)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().deny(invitedIdentity, invitingIdentity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getOwnerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(invitedIdentity, invitingIdentity);
        }
    }
}

