/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UIPageNodeForm;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceNavigationManagement.gtmpl", events={@EventConfig(listeners={AddRootNodeActionListener.class}), @EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={SaveActionListener.class})}), @ComponentConfig(type=UIPageNodeForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm.SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchLabelModeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchVisibleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.CreatePageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, id="AddNode", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup")})})
public class UISpaceNavigationManagement
extends UIContainer {
    private String owner;
    private String ownerType;
    private Space space;

    public UISpaceNavigationManagement() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, "AddNode", null);
        uiPopup.setWindowSize(800, 445);
        uiPopup.setShow(false);
        this.addChild((UIComponent)uiPopup);
        this.addChild(UISpaceNavigationNodeSelector.class, null, null);
        this.reloadTreeData();
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        return (T)super.setRendered(b);
    }

    public void reloadTreeData() throws Exception {
        UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        String spaceUrl = SpaceUtils.getSpaceUrl();
        Space space = spaceService.getSpaceByUrl(spaceUrl);
        UserNavigation groupNav = SpaceUtils.getGroupNavigation((String)space.getGroupId());
        this.setOwner(groupNav.getKey().getName());
        this.setOwnerType(groupNav.getKey().getTypeName());
        UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)this.getChild(UISpaceNavigationNodeSelector.class);
        selector.setEdittedNavigation(groupNav);
        selector.setUserPortal(userPortal);
        selector.initTreeData();
    }

    public void loadView(Event<? extends UIComponent> event) throws Exception {
        UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)this.getChild(UISpaceNavigationNodeSelector.class);
        UITree uiTree = (UITree)uiNodeSelector.getChild(UITree.class);
        uiTree.createEvent("ChangeNode", event.getExecutionPhase(), event.getRequestContext()).broadcast();
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    protected void setSpace(Space space) {
        this.space = space;
    }

    protected Space getSpace() {
        return this.space;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClosePopupActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)event.getSource();
            UISpaceNavigationManagement uiSpaceNavManagement = (UISpaceNavigationManagement)uiPopup.getAncestorOfType(UISpaceNavigationManagement.class);
            UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)uiSpaceNavManagement.getChild(UISpaceNavigationNodeSelector.class);
            UserNavigation contextNavigation = selector.getEdittedNavigation();
            uiPopup.setShow(false);
            uiSpaceNavManagement.setOwner(contextNavigation.getKey().getName());
            uiSpaceNavManagement.setOwnerType(contextNavigation.getKey().getTypeName());
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceNavManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNode = (UIPageNodeForm)((Object)event.getSource());
            UserNavigation contextNavigation = uiPageNode.getContextPageNavigation();
            UISpaceNavigationManagement uiSpaceNavManagement = (UISpaceNavigationManagement)uiPageNode.getAncestorOfType(UISpaceNavigationManagement.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceNavManagement.getChild(UIPopupWindow.class);
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISpaceNavigationManagement> {
        public void execute(Event<UISpaceNavigationManagement> event) throws Exception {
            UserNavigation persistNavigation;
            UserPortalConfig userPortalConfig;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UISpaceNavigationManagement uiManagement = (UISpaceNavigationManagement)((Object)event.getSource());
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiManagement.getChild(UISpaceNavigationNodeSelector.class);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.ignoreAJAXUpdateOnPortlets(true);
            UserNavigation navigation = uiNodeSelector.getEdittedNavigation();
            SiteKey siteKey = navigation.getKey();
            String editedOwnerId = siteKey.getName();
            if (SiteType.PORTAL.equals((Object)siteKey.getType())) {
                userPortalConfig = portalConfigService.getUserPortalConfig(editedOwnerId, event.getRequestContext().getRemoteUser());
                if (userPortalConfig == null) {
                    prContext.getUIApplication().addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null, 0));
                    return;
                }
            } else {
                userPortalConfig = portalConfigService.getUserPortalConfig(prContext.getPortalOwner(), event.getRequestContext().getRemoteUser());
            }
            if ((persistNavigation = userPortalConfig.getUserPortal().getNavigation(siteKey)) == null) {
                prContext.getUIApplication().addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null, 0));
                return;
            }
            uiNodeSelector.save();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeActionListener
    extends EventListener<UISpaceNavigationManagement> {
        public void execute(Event<UISpaceNavigationManagement> event) throws Exception {
            UISpaceNavigationManagement uiManagement = (UISpaceNavigationManagement)((Object)event.getSource());
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiManagement.getChild(UISpaceNavigationNodeSelector.class);
            UIRightClickPopupMenu menu = (UIRightClickPopupMenu)uiNodeSelector.getChild(UIRightClickPopupMenu.class);
            menu.createEvent("AddNode", Event.Phase.PROCESS, event.getRequestContext()).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UISpaceNavigationManagement> {
        public void execute(Event<UISpaceNavigationManagement> event) throws Exception {
            UISpaceNavigationManagement uiManagement = (UISpaceNavigationManagement)((Object)event.getSource());
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiManagement.getChild(UISpaceNavigationNodeSelector.class);
            UIRightClickPopupMenu menu = (UIRightClickPopupMenu)uiNodeSelector.getChild(UIRightClickPopupMenu.class);
            menu.createEvent("AddNode", Event.Phase.PROCESS, event.getRequestContext()).broadcast();
        }
    }
}

