/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.List;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/UIApplicationCategorySelector.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIApplicationCategorySelector
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIApplicationCategorySelector.class);
    private List<ApplicationCategory> applicationCategoryList;
    private ApplicationCategory selectedApplicationCategory;

    public final void setApplicationCategoryList(List<ApplicationCategory> newApplicationCategoryList) {
        this.applicationCategoryList = newApplicationCategoryList;
    }

    public final List<ApplicationCategory> getApplicationCategoryList() {
        return this.applicationCategoryList;
    }

    public final void setSelectedApplicationCategory(ApplicationCategory newApplicationCategory) {
        this.selectedApplicationCategory = newApplicationCategory;
    }

    public final ApplicationCategory getSelectedApplicationCategory() {
        if (this.selectedApplicationCategory == null) {
            this.selectedApplicationCategory = this.applicationCategoryList.get(0);
        }
        return this.selectedApplicationCategory;
    }

    private void setSelectedApplicationCategory(String categoryName) {
        if (this.getSelectedApplicationCategory().getName().equals(categoryName)) {
            return;
        }
        for (ApplicationCategory applicationCategory : this.applicationCategoryList) {
            if (!categoryName.equals(applicationCategory.getName())) continue;
            this.setSelectedApplicationCategory(applicationCategory);
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIApplicationCategorySelector> {
        public void execute(Event<UIApplicationCategorySelector> event) throws Exception {
            UIApplicationCategorySelector uiApplicationCategorySelector = (UIApplicationCategorySelector)((Object)event.getSource());
            String categoryName = event.getRequestContext().getRequestParameter("objectId");
            uiApplicationCategorySelector.setSelectedApplicationCategory(categoryName);
            if (uiApplicationCategorySelector.getParent() != null) {
                Event selectEvent = uiApplicationCategorySelector.getParent().createEvent("Select", Event.Phase.DECODE, event.getRequestContext());
                if (selectEvent == null) {
                    LOG.warn((Object)"Failed to broadcast SelectItemActionListener.");
                    return;
                }
                selectEvent.broadcast();
            }
        }
    }
}

