/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserActivityListAccess
implements ListAccess<ExoSocialActivity> {
    private static final Log LOG = ExoLogger.getLogger(UserActivityListAccess.class);
    private Identity ownerIdentity;
    private UIUserActivitiesDisplay.DisplayMode displayMode;

    public UserActivityListAccess(Identity ownerIdentity, UIUserActivitiesDisplay.DisplayMode displayMode) {
        this.ownerIdentity = ownerIdentity;
        this.displayMode = displayMode;
    }

    public int getSize() throws Exception {
        int size = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? Utils.getActivityManager().getActivitiesCount(this.ownerIdentity) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACE_UPDATES ? Utils.getActivityManager().getActivitiesOfUserSpaces(this.ownerIdentity).size() : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.NETWORK_UPDATES ? Utils.getActivityManager().getActivitiesOfConnections(this.ownerIdentity).size() : Utils.getActivityManager().getActivityFeedWithListAccess(this.ownerIdentity).getSize()));
        return size;
    }

    public ExoSocialActivity[] load(int index, int length) throws Exception {
        List<Object> activityList = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? Utils.getActivityManager().getActivities(this.ownerIdentity, (long)index, (long)length) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACE_UPDATES ? this.getActivitiesOfUserSpaces(index, length) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.NETWORK_UPDATES ? this.getActivitiesOfConnections(index, length) : Utils.getActivityManager().getActivityFeedWithListAccess(this.ownerIdentity).loadAsList(index, length)));
        return activityList == null ? null : activityList.toArray(new ExoSocialActivity[activityList.size()]);
    }

    private List<ExoSocialActivity> getActivitiesOfConnections(int index, int length) throws Exception {
        List activityList = Utils.getActivityManager().getActivitiesOfConnections(this.ownerIdentity);
        return this.getActivityList(index, length, activityList);
    }

    private List<ExoSocialActivity> getActivitiesOfUserSpaces(int index, int length) {
        List activityList = Utils.getActivityManager().getActivitiesOfUserSpaces(this.ownerIdentity);
        return this.getActivityList(index, length, activityList);
    }

    private List<ExoSocialActivity> getActivityList(int index, int length, List<ExoSocialActivity> activityList) {
        if (activityList == null) {
            return new ArrayList<ExoSocialActivity>();
        }
        int maxIndex = activityList.size();
        if (maxIndex < 1) {
            return activityList;
        }
        int toIndex = length + index;
        toIndex = Math.min(activityList.size(), toIndex);
        return activityList.subList(index, toIndex);
    }
}

