/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.extras.benches.ExoSocialDataInjectionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoSocialDataInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(ExoSocialDataInjector.class);
    private long numberOfUser;
    private long numberOfRelation;
    private long numberOfActivity;
    private int numberOfSpace;
    private int numberOfActivitySpace;
    private ExoSocialDataInjectionExecutor injector;
    private Map<String, Long> userActivities = new HashMap<String, Long>();
    private Collection<Identity> identities = null;
    Map<Space, Identity> spaceIdentityMap = null;

    public ExoSocialDataInjector(ExoSocialDataInjectionExecutor injector) {
        this.injector = injector;
    }

    public Object execute(HashMap<String, String> arg0) throws Exception {
        return null;
    }

    public Log getLog() {
        return LOG;
    }

    public void inject(HashMap<String, String> paramsMap) throws Exception {
        this.initParams(paramsMap);
        this.executeInject();
    }

    private void executeInject() {
        LOG.info((Object)"starting...");
        boolean nothingWasDone = true;
        if (this.numberOfUser > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfUser + " people."));
            this.identities = this.injector.generatePeople(this.numberOfUser);
        }
        if (this.numberOfRelation > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfRelation + " connections."));
            this.injector.generateRelations(this.numberOfRelation);
        }
        if (this.numberOfActivity > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfActivity + " activities."));
            this.injector.generateActivities(this.numberOfActivity);
        }
        if (!this.userActivities.isEmpty()) {
            Set<Map.Entry<String, Long>> entries = this.userActivities.entrySet();
            for (Map.Entry<String, Long> entry : entries) {
                String username = entry.getKey();
                Long count = entry.getValue();
                LOG.info((Object)("\t> about to inject " + count + " activities for " + username + "."));
                this.injector.generateActivities(username, (long)count);
            }
        }
        if (this.numberOfSpace > 0) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfSpace + " spaces."));
            this.spaceIdentityMap = this.injector.generateSpaces(this.identities, this.numberOfSpace);
        }
        if (this.numberOfActivitySpace > 0) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfActivity + " activity spaces."));
            Set<Space> spaceSet = this.spaceIdentityMap.keySet();
            for (Space space : spaceSet) {
                Identity identity = this.spaceIdentityMap.get(space);
                this.injector.generateActivitySpace(space, identity, this.numberOfActivitySpace);
            }
        }
        if (nothingWasDone) {
            LOG.info((Object)"nothing to inject.");
        }
    }

    private void initParams(HashMap<String, String> paramsMap) {
        if (paramsMap != null) {
            String value = paramsMap.get("mU");
            this.numberOfUser = this.longValue("mU", value);
            value = paramsMap.get("mR");
            this.numberOfRelation = this.longValue("mR", value);
            value = paramsMap.get("mA");
            this.numberOfActivity = this.longValue("mA", value);
            value = paramsMap.get("mS");
            this.numberOfSpace = this.intValue("mS", value);
            value = paramsMap.get("mSA");
            this.numberOfActivitySpace = this.intValue("mSA", value);
        }
    }

    public void reject(HashMap<String, String> arg0) throws Exception {
    }

    private long longValue(String property, String value) {
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Long number expected for property " + property));
        }
        return 0L;
    }

    private int intValue(String property, String value) {
        try {
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + property));
        }
        return 0;
    }
}

