/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.extras.benches.ExoSocialDataInjectionExecutor;
import org.exoplatform.social.extras.benches.util.Range;
import org.exoplatform.social.extras.benches.util.RangeCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoSocialExtensionDataInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(ExoSocialExtensionDataInjector.class);
    private long numberOfUser;
    private long[] relationRanks;
    private long[] activityRanks;
    private long numberOfSpace;
    private long[] activitySpaceRanks;
    private ExoSocialDataInjectionExecutor injector;
    private Collection<Identity> identities = null;
    private Map<Space, Identity> identitySpacesMap = null;

    public ExoSocialExtensionDataInjector(ExoSocialDataInjectionExecutor injector) {
        this.injector = injector;
    }

    public Object execute(HashMap<String, String> arg0) throws Exception {
        return null;
    }

    public Log getLog() {
        return LOG;
    }

    public void inject(HashMap<String, String> paramsMap) throws Exception {
        this.initParams(paramsMap);
        this.executeInject();
    }

    private void executeInject() {
        LOG.info((Object)"starting...");
        boolean nothingWasDone = true;
        nothingWasDone = this.executePeopleInjector(nothingWasDone);
        nothingWasDone = this.executeRelationInjector(nothingWasDone);
        nothingWasDone = this.executeActivityInjector(nothingWasDone);
        nothingWasDone = this.executeSpaceInjector(nothingWasDone);
        nothingWasDone = this.executeAcivitySpaceInjector(nothingWasDone);
        if (nothingWasDone) {
            LOG.info((Object)"nothing to inject.");
        }
    }

    private boolean executeAcivitySpaceInjector(boolean nothingWasDone) {
        if (this.activitySpaceRanks.length > 0) {
            nothingWasDone = false;
            this.numberOfSpace *= this.numberOfUser;
            Range[] activitySpaceRanges = RangeCalculator.calculateRange(this.numberOfSpace, this.activitySpaceRanks);
            Space[] spaceArray = this.identitySpacesMap.keySet().toArray(new Space[0]);
            if (this.numberOfSpace != (long)spaceArray.length) {
                throw new IllegalArgumentException("Wrong::the space array's length is not equals numberOfSpace.");
            }
            for (int i = 0; i < activitySpaceRanges.length; ++i) {
                long low = activitySpaceRanges[i].getLow();
                long high = activitySpaceRanges[i].getHigh();
                long amount = activitySpaceRanges[i].getAmount();
                for (long j = low; j < high; ++j) {
                    Space space = spaceArray[(int)j];
                    Identity identity = this.identitySpacesMap.get(space);
                    LOG.info((Object)("\t> about to inject " + amount + " activity spaces."));
                    this.injector.generateActivitySpace(space, identity, amount);
                }
            }
        }
        return nothingWasDone;
    }

    private boolean executeSpaceInjector(boolean nothingWasDone) {
        if (this.numberOfSpace > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfSpace + " spaces."));
            this.identitySpacesMap = this.injector.generateSpaces(this.identities, this.numberOfSpace);
        }
        return nothingWasDone;
    }

    private boolean executeActivityInjector(boolean nothingWasDone) {
        if (this.activityRanks.length > 0) {
            nothingWasDone = false;
            Range[] activityRanges = RangeCalculator.calculateRange(this.numberOfUser, this.activityRanks);
            Identity[] identityArr = this.identities.toArray(new Identity[0]);
            if (this.numberOfUser != (long)identityArr.length) {
                throw new IllegalArgumentException("Wrong::the identity array's length is not equals numberOfUser.");
            }
            for (int i = 0; i < activityRanges.length; ++i) {
                long low = activityRanges[i].getLow();
                long high = activityRanges[i].getHigh();
                long amount = activityRanges[i].getAmount();
                for (long j = low; j < high; ++j) {
                    Identity identity = identityArr[(int)j];
                    LOG.info((Object)("\t> about to inject " + amount + " activities for identity = " + identity.getRemoteId()));
                    this.injector.generateActivities(identity, amount);
                }
            }
        }
        return nothingWasDone;
    }

    private boolean executePeopleInjector(boolean nothingWasDone) {
        if (this.numberOfUser > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfUser + " people."));
            this.identities = this.injector.generatePeople(this.numberOfUser);
        }
        return nothingWasDone;
    }

    private boolean executeRelationInjector(boolean nothingWasDone) {
        if (this.relationRanks.length > 0) {
            nothingWasDone = false;
            Range[] relationRanges = RangeCalculator.calculateRange(this.numberOfUser, this.relationRanks);
            for (int i = 0; i < relationRanges.length; ++i) {
                long low = relationRanges[i].getLow();
                long high = relationRanges[i].getHigh();
                long amount = relationRanges[i].getAmount();
                for (long j = low; j < high; ++j) {
                    LOG.info((Object)("\t> about to inject " + amount + " connections."));
                    this.injector.generateRelations(amount);
                }
            }
        }
        return nothingWasDone;
    }

    private void initParams(HashMap<String, String> paramsMap) {
        if (paramsMap != null) {
            String value = paramsMap.get("mU");
            this.numberOfUser = this.longValue("mU", value);
            value = paramsMap.get("mRpU");
            String[] values = value.split(",");
            this.relationRanks = this.longValues("mRpU", values);
            value = paramsMap.get("mA");
            values = value.split(",");
            this.activityRanks = this.longValues("mA", values);
            value = paramsMap.get("mS");
            this.numberOfSpace = this.IntValue("mS", value);
            value = paramsMap.get("mSA");
            values = value.split(",");
            this.activitySpaceRanks = this.longValues("mSA", values);
        }
    }

    public void reject(HashMap<String, String> arg0) throws Exception {
    }

    private long longValue(String property, String value) {
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Long number expected for property " + property));
        }
        return 0L;
    }

    private long[] longValues(String property, String[] values) {
        long[] result = new long[values.length];
        try {
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    result[i] = Long.valueOf(values[i]);
                }
            }
            return result;
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Long number expected for property " + property));
            return new long[0];
        }
    }

    private int IntValue(String property, String value) {
        try {
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + property));
        }
        return 0;
    }
}

