/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/plugin/doc/UIDocActivityComposer.gtmpl", events={@EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class}), @EventConfig(listeners={SelectDocumentActionListener.class})})
public class UIDocActivityComposer
extends UIActivityComposer
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityComposer.class);
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    private final String POPUP_COMPOSER = "UIPopupComposer";
    private String documentRefLink;
    private String rootpath;
    private String documentPath;
    private String documentName;
    private boolean isDocumentReady;

    public UIDocActivityComposer() {
        this.resetValues();
    }

    private void resetValues() {
        this.documentRefLink = "";
        this.isDocumentReady = false;
        this.setReadyForPostingActivity(false);
    }

    public boolean isDocumentReady() {
        return this.isDocumentReady;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    protected void onActivate(Event<UIActivityComposer> event) {
        this.isDocumentReady = false;
        this.rootpath = "/Users/" + event.getRequestContext().getRemoteUser();
        UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
        this.showDocumentPopup(docActivityComposer);
    }

    private void showDocumentPopup(UIDocActivityComposer docActivityComposer) {
        UIComponent child;
        UIComposer uiComposer = (UIComposer)docActivityComposer.getAncestorOfType(UIComposer.class);
        UIContainer optionContainer = uiComposer.getOptionContainer();
        UIPopupWindow uiPopup = (UIPopupWindow)optionContainer.getChild(UIPopupWindow.class);
        if (uiPopup == null) {
            try {
                uiPopup = (UIPopupWindow)optionContainer.addChild(UIPopupWindow.class, null, "UIPopupComposer");
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        if ((child = uiPopup.getUIComponent()) != null && child instanceof UIOneNodePathSelector) {
            try {
                UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)child;
                uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
                uiPopup.setShow(true);
                uiPopup.setResizable(true);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        } else {
            try {
                uiPopup.setWindowSize(600, 600);
                UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)uiPopup.createUIComponent(UIOneNodePathSelector.class, null, "UIOneNodePathSelector");
                uiOneNodePathSelector.setIsDisable(WORKSPACE, true);
                uiOneNodePathSelector.setIsShowSystem(false);
                uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(new String[]{"nt:file"});
                uiOneNodePathSelector.setRootNodeLocation(REPOSITORY, WORKSPACE, this.rootpath);
                uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
                uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
                uiOneNodePathSelector.setSourceComponent((UIComponent)this, null);
                uiPopup.setShow(true);
                uiPopup.setResizable(true);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    protected void onClose(Event<UIActivityComposer> event) {
        this.resetValues();
    }

    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        if (!this.isDocumentReady) {
            requestContext.getUIApplication().addMessage(new ApplicationMessage("You have to choose document first!!!", null, 2));
        } else {
            JSONObject jsonData = new JSONObject();
            jsonData.put("DOCNAME", (Object)this.documentName);
            jsonData.put("DOCLINK", (Object)this.documentRefLink);
            jsonData.put("DOCPATH", (Object)this.documentPath);
            jsonData.put("REPOSITORY", (Object)REPOSITORY);
            jsonData.put("WORKSPACE", (Object)WORKSPACE);
            jsonData.put("MESSAGE", (Object)postedMessage);
            String activityJSONData = jsonData.toString();
            UIApplication uiApplication = requestContext.getUIApplication();
            if (activityJSONData.equals("")) {
                uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            } else if (postContext == UIComposer.PostContext.SPACE) {
                this.postActivityToSpace(source, requestContext, activityJSONData);
            } else if (postContext == UIComposer.PostContext.USER) {
                this.postActivityToUser(source, requestContext, activityJSONData);
            }
        }
        this.resetValues();
    }

    private void postActivityToUser(UIComponent source, WebuiRequestContext requestContext, String jsonData) throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
        UIComposer uiComposer = (UIComposer)source;
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        String ownerName = uiUserActivitiesDisplay.getOwnerName();
        Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName);
        String remoteUser = requestContext.getRemoteUser();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser);
        Activity activity = new Activity(userIdentity.getId(), "exosocial:people", jsonData, null);
        activity.setType("DOC_ACTIVITY");
        activityManager.saveActivity(ownerIdentity, activity);
        uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.MY_STATUS);
    }

    private void postActivityToSpace(UIComponent source, WebuiRequestContext requestContext, String jsonData) throws Exception {
        UIComposer uiComposer = (UIComposer)source;
        SpaceService spaceSrv = (SpaceService)uiComposer.getApplicationComponent(SpaceService.class);
        Space space = spaceSrv.getSpaceByUrl(SpaceUtils.getSpaceUrl());
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getId(), false);
        String remoteUser = requestContext.getRemoteUser();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser);
        Activity activity = new Activity(userIdentity.getId(), "exosocial:spaces", jsonData, null);
        activity.setType("DOC_ACTIVITY");
        activityManager.saveActivity(spaceIdentity, activity);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String rawPath = value.toString();
        rawPath = rawPath.substring(rawPath.indexOf(":/") + 2);
        this.documentRefLink = this.buildDocumentLink(rawPath);
        this.documentName = rawPath.substring(rawPath.lastIndexOf("/") + 1);
        this.documentPath = this.buildDocumentPath(rawPath);
        this.isDocumentReady = true;
        this.documentRefLink = this.documentRefLink.replace("//", "/");
        this.documentPath = this.documentPath.replace("//", "/");
        this.setReadyForPostingActivity(true);
    }

    private String buildDocumentLink(String rawPath) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return "/" + portalContainerName + "/" + restContextName + "/" + restService + "/" + REPOSITORY + "/" + WORKSPACE + this.rootpath + "/" + rawPath;
    }

    public String buildDocumentPath(String rawPath) {
        return this.rootpath + "/" + rawPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            docActivityComposer.rootpath = "/Users/" + event.getRequestContext().getRemoteUser() + "/";
            docActivityComposer.showDocumentPopup(docActivityComposer);
        }
    }
}

