/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipInjector
extends AbstractSocialInjector {
    private static final String NUMBER = "number";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";

    public void inject(HashMap<String, String> params) throws Exception {
        this.init();
        int number = this.param(params, NUMBER);
        int from = this.param(params, FROM_USER);
        int to = this.param(params, TO_USER);
        if (number <= 0) {
            this.getLog().error((Object)("Number have to be positive. Value '" + number + "' incorrect. Aborting injection ..."));
            return;
        }
        Map<Integer, Integer> computed = this.compute(from, to, number);
        this.getLog().info((Object)"About to inject relationships :");
        for (Integer key : computed.keySet()) {
            this.getLog().info((Object)("" + key + " user(s) with " + computed.get(key) + " connection(s)"));
        }
        block1: for (int i = from; i <= to; ++i) {
            String fromUser = "bench.user" + i;
            Identity identity1 = this.identityManager.getOrCreateIdentity("organization", fromUser, false);
            int target = number + from;
            for (int j = from; j < target; ++j) {
                boolean exists;
                if (i == j) {
                    ++target;
                    continue;
                }
                if (j > to) continue block1;
                String toUser = "bench.user" + j;
                Identity identity2 = this.identityManager.getOrCreateIdentity("organization", toUser, false);
                boolean bl = exists = this.relationshipManager.get(identity1, identity2) != null;
                if (!exists) {
                    int size = this.relationshipManager.getConnections(identity2).getSize();
                    if (size >= number) {
                        ++target;
                        continue;
                    }
                    Relationship r = this.relationshipManager.inviteToConnect(identity1, identity2);
                    r.setStatus(Relationship.Type.CONFIRMED);
                    this.relationshipManager.update(r);
                    this.getLog().info((Object)("Relationship between " + fromUser + " and " + toUser + " generated"));
                    continue;
                }
                this.getLog().info((Object)("Relationship between " + fromUser + " and " + toUser + " already exists"));
            }
        }
    }

    public boolean isPossible(int a, int b, int c) {
        return ((float)(b - a) + 1.0f) % ((float)c + 1.0f) == 0.0f;
    }

    public Map<Integer, Integer> compute(int a, int b, int c) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (c > b - a) {
            result.put(b - a + 1, b - a);
        } else if (this.isPossible(a, b, c)) {
            result.put(b - a + 1, c);
        } else {
            int group = (int)(((float)(b - a) + 1.0f) / ((float)c + 1.0f));
            int exact = group * (c + 1);
            int remaining = b - a + 1 - exact;
            result.put(exact, c);
            result.put(remaining, remaining - 1);
        }
        return result;
    }
}

