/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jboss.security.negotiation.DelegatingMessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageFactory {
    private static final Logger log = Logger.getLogger(MessageFactory.class);
    private static final String NTLM_MESSAGE_FACTORY_NAME = "org.jboss.security.negotiation.ntlm.NTLMMessageFactory";
    private static final String SPNEGO_MESSAGE_FACTORY_NAME = "org.jboss.security.negotiation.spnego.SPNEGOMessageFactory";
    private static final Class<MessageFactory> NTLM_MESSAGE_FACTORY = MessageFactory.loadClass("org.jboss.security.negotiation.ntlm.NTLMMessageFactory");
    private static final Class<MessageFactory> SPNEGO_MESSAGE_FACTORY = MessageFactory.loadClass("org.jboss.security.negotiation.spnego.SPNEGOMessageFactory");

    private static Class<MessageFactory> loadClass(String classname) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<MessageFactory> clazz = null;
        try {
            clazz = classLoader.loadClass(classname);
        }
        catch (Exception e) {
            log.trace((Object)("Unable to load class '" + classname + "'"), (Throwable)e);
        }
        return clazz;
    }

    public static MessageFactory newInstance() throws NegotiationException {
        MessageFactory ntlm = MessageFactory.newInstance(NTLM_MESSAGE_FACTORY);
        MessageFactory spnego = MessageFactory.newInstance(SPNEGO_MESSAGE_FACTORY);
        if (ntlm != null && spnego != null) {
            ArrayList<MessageFactory> delegates = new ArrayList<MessageFactory>(2);
            delegates.add(spnego);
            delegates.add(ntlm);
            return new DelegatingMessageFactory(delegates);
        }
        if (ntlm != null) {
            return ntlm;
        }
        if (spnego != null) {
            return spnego;
        }
        throw new IllegalStateException("No MessageFactories available to instantiate");
    }

    private static MessageFactory newInstance(Class<MessageFactory> clazz) throws NegotiationException {
        MessageFactory response = null;
        if (clazz != null) {
            try {
                response = clazz.newInstance();
            }
            catch (Exception e) {
                throw new NegotiationException("Unable to instantiate '" + clazz.getName() + "'", e);
            }
        }
        return response;
    }

    public abstract boolean accepts(InputStream var1) throws IOException;

    public abstract NegotiationMessage createMessage(InputStream var1) throws IOException;
}

