/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedComponentComponent
extends AbstractManagedComponent
implements ConfigurationFacet,
DeleteResourceFacet,
OperationFacet,
MeasurementFacet {
    public static final String COMPONENT_NAME_PROPERTY = "componentName";
    protected static final char PREFIX_DELIMITER = '|';
    private final Log log = LogFactory.getLog(this.getClass());
    private String componentName;
    private ComponentType componentType;

    public AvailabilityType getAvailability() {
        RunState runState = this.getManagedComponent().getRunState();
        return runState == RunState.RUNNING ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    @Override
    public void start(ResourceContext<ProfileServiceComponent> resourceContext) throws Exception {
        super.start(resourceContext);
        this.componentType = ConversionUtils.getComponentType(this.getResourceContext().getResourceType());
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        this.componentName = pluginConfig.getSimple(COMPONENT_NAME_PROPERTY).getStringValue();
        this.log.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.componentType + " component '" + this.componentName + "'."));
    }

    @Override
    public void stop() {
    }

    public void deleteResource() throws Exception {
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        if (!deploymentManager.isRedeploySupported()) {
            throw new UnsupportedOperationException("Deletion of " + this.getResourceContext().getResourceType().getName() + " Resources is not currently supported.");
        }
        ManagedComponent managedComponent = this.getManagedComponent();
        this.log.debug((Object)("Removing " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.removeComponent(managedComponent);
        ManagedDeployment parentDeployment = managedComponent.getDeployment();
        this.log.debug((Object)("Redeploying parent deployment '" + parentDeployment.getName() + "' in order to complete removal of component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        DeploymentProgress progress = deploymentManager.redeploy(parentDeployment.getName());
        DeploymentStatus redeployStatus = DeploymentUtils.run(progress);
        if (redeployStatus.isFailed()) {
            this.log.error((Object)("Failed to redeploy parent deployment '" + parentDeployment.getName() + "during removal of component " + ManagedComponentComponent.toString(managedComponent) + " - removal may not persist when the app server is restarted."), (Throwable)redeployStatus.getFailure());
        }
        managementView.load();
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        OperationDefinition operationDefinition = this.getOperationDefinition(name);
        ManagedOperation managedOperation = this.getManagedOperation(operationDefinition);
        MetaValue[] parameterMetaValues = ConversionUtils.convertOperationsParametersToMetaValues(managedOperation, parameters, operationDefinition);
        MetaValue resultMetaValue = managedOperation.invoke(parameterMetaValues);
        OperationResult result = new OperationResult();
        ConversionUtils.convertManagedOperationResults(managedOperation, resultMetaValue, result.getComplexResults(), operationDefinition);
        return result;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        ManagedComponent managedComponent = this.getManagedComponent();
        for (MeasurementScheduleRequest request : metrics) {
            try {
                if (request.getName().equals("runState")) {
                    String runState = managedComponent.getRunState().name();
                    report.addData(new MeasurementDataTrait(request, runState));
                    continue;
                }
                Object value = this.getSimpleValue(managedComponent, request);
                this.addValueToMeasurementReport(report, request, value);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric for " + request), (Throwable)e);
            }
        }
    }

    @Override
    protected Map<String, ManagedProperty> getManagedProperties() {
        return this.getManagedComponent().getProperties();
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    protected void updateComponent() throws Exception {
        ManagedComponent managedComponent = this.getManagedComponent();
        this.log.trace((Object)("Updating " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.updateComponent(managedComponent);
        managementView.load();
    }

    protected Object getSimpleValue(ManagedComponent managedComponent, MeasurementScheduleRequest request) {
        MetaValue metaValue;
        String metricName = request.getName();
        int pipeIndex = metricName.indexOf(124);
        String compositePropName = pipeIndex == -1 ? metricName : metricName.substring(pipeIndex + 1);
        int dotIndex = compositePropName.indexOf(46);
        String metricPropName = dotIndex == -1 ? compositePropName : compositePropName.substring(0, dotIndex);
        ManagedProperty metricProp = managedComponent.getProperty(metricPropName);
        if (dotIndex == -1) {
            metaValue = metricProp.getValue();
        } else {
            CompositeValue compositeValue = (CompositeValue)metricProp.getValue();
            String key = compositePropName.substring(dotIndex + 1);
            metaValue = compositeValue.get(key);
        }
        return ManagedComponentComponent.getInnerValue(metaValue);
    }

    private static Object getInnerValue(MetaValue metaValue) {
        ArrayList<Object> value;
        if (metaValue == null) {
            return null;
        }
        if (metaValue.getMetaType().isSimple()) {
            SimpleValue simpleValue = (SimpleValue)metaValue;
            value = simpleValue.getValue();
        } else if (metaValue.getMetaType().isEnum()) {
            EnumValue enumValue = (EnumValue)metaValue;
            value = enumValue.getValue();
        } else if (metaValue.getMetaType().isArray()) {
            ArrayValue arrayValue = (ArrayValue)metaValue;
            value = arrayValue.getValue();
        } else if (metaValue.getMetaType().isCollection()) {
            CollectionValue collectionValue = (CollectionValue)metaValue;
            ArrayList<Object> list = new ArrayList<Object>();
            for (MetaValue element : collectionValue.getElements()) {
                list.add(ManagedComponentComponent.getInnerValue(element));
            }
            value = list;
        } else {
            value = metaValue.toString();
        }
        return value;
    }

    protected void addValueToMeasurementReport(MeasurementReport report, MeasurementScheduleRequest request, Object value) {
        if (value == null) {
            return;
        }
        String stringValue = ManagedComponentComponent.toString(value);
        DataType dataType = request.getDataType();
        switch (dataType) {
            case MEASUREMENT: {
                try {
                    MeasurementDataNumeric dataNumeric = new MeasurementDataNumeric(request, Double.valueOf(stringValue));
                    report.addData(dataNumeric);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("Profile service did not return a numeric value as expected for metric [" + request.getName() + "] - value returned was " + value + "."), (Throwable)e);
                }
                break;
            }
            case TRAIT: {
                MeasurementDataTrait dataTrait = new MeasurementDataTrait(request, stringValue);
                report.addData(dataTrait);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported measurement data type: " + dataType);
            }
        }
    }

    protected ManagedComponent getManagedComponent() {
        ManagedComponent managedComponent;
        try {
            ManagementView managementView = this.getConnection().getManagementView();
            managedComponent = ManagedComponentUtils.getManagedComponent(managementView, this.componentType, this.componentName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load [" + this.componentType + "] ManagedComponent [" + this.componentName + "].", e);
        }
        if (managedComponent == null) {
            throw new IllegalStateException("Failed to find [" + this.componentType + "] ManagedComponent named [" + this.componentName + "].");
        }
        this.log.trace((Object)("Retrieved " + ManagedComponentComponent.toString(managedComponent) + "."));
        return managedComponent;
    }

    @NotNull
    private OperationDefinition getOperationDefinition(String operationName) {
        ResourceType resourceType = this.getResourceContext().getResourceType();
        OperationDefinition operationDefinition = ResourceTypeUtils.getOperationDefinition(resourceType, operationName);
        if (operationDefinition == null) {
            throw new IllegalStateException("Operation named '" + operationName + "' is not defined for Resource type '" + resourceType.getName() + "' in the '" + resourceType.getPlugin() + "' plugin's descriptor.");
        }
        return operationDefinition;
    }

    @NotNull
    private ManagedOperation getManagedOperation(OperationDefinition operationDefinition) {
        ManagedComponent managedComponent = this.getManagedComponent();
        Set operations = managedComponent.getOperations();
        for (ManagedOperation operation : operations) {
            int paramCount;
            ConfigurationDefinition paramsConfigDef = operationDefinition.getParametersConfigurationDefinition();
            int n = paramCount = paramsConfigDef != null ? paramsConfigDef.getPropertyDefinitions().size() : 0;
            if (!operation.getName().equals(operationDefinition.getName()) || operation.getParameters().length != paramCount) continue;
            return operation;
        }
        throw new IllegalStateException("ManagedOperation named '" + operationDefinition.getName() + "' not found on ManagedComponent [" + this.getManagedComponent() + "].");
    }

    private static String toString(ManagedComponent managedComponent) {
        Map properties = managedComponent.getProperties();
        return managedComponent.getClass().getSimpleName() + "@" + System.identityHashCode(managedComponent) + "[" + "type=" + managedComponent.getType() + ", name=" + managedComponent.getName() + ", properties=" + properties.getClass().getSimpleName() + "@" + System.identityHashCode(properties) + "]";
    }

    private static String toString(@NotNull Object value) {
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int lastIndex = Array.getLength(value) - 1;
            for (int i = 0; i < Array.getLength(value); ++i) {
                buffer.append(String.valueOf(Array.get(value, i)));
                if (i == lastIndex) break;
                buffer.append(", ");
            }
            return buffer.toString();
        }
        return value.toString();
    }

    public static interface Config {
        public static final String COMPONENT_TYPE = "componentType";
        public static final String COMPONENT_SUBTYPE = "componentSubtype";
        public static final String COMPONENT_NAME = "componentName";
        public static final String TEMPLATE_NAME = "templateName";
        public static final String RESOURCE_NAME = "resourceName";
    }
}

