/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.ejb.EJB;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.wsf.common.injection.resolvers.AbstractReferenceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EJBBeanReferenceResolver
extends AbstractReferenceResolver<EJB> {
    private final DeploymentUnit unit;
    private final EjbReferenceResolver delegate;

    EJBBeanReferenceResolver(DeploymentUnit unit, EjbReferenceResolver delegate) {
        super(EJB.class);
        if (unit == null) {
            throw new IllegalArgumentException("Deployment unit cannot be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("Ejb reference resolver cannot be null");
        }
        this.unit = unit;
        this.delegate = delegate;
    }

    protected String resolveField(Field field) {
        EJB ejbAnnotation = field.getAnnotation(EJB.class);
        Class<?> type = field.getType();
        EjbReference reference = this.getEjbReference(ejbAnnotation, type);
        return this.delegate.resolveEjb(this.unit, reference);
    }

    protected String resolveMethod(Method method) {
        EJB ejbAnnotation = method.getAnnotation(EJB.class);
        Class<?> type = method.getParameterTypes()[0];
        EjbReference reference = this.getEjbReference(ejbAnnotation, type);
        return this.delegate.resolveEjb(this.unit, reference);
    }

    private EjbReference getEjbReference(EJB ejbAnnotation, Class<?> type) {
        String beanInterface = ejbAnnotation.beanInterface().getName();
        if (Object.class.getName().equals(beanInterface)) {
            beanInterface = type.getName();
        }
        return new EjbReference(ejbAnnotation.beanName(), beanInterface, ejbAnnotation.mappedName());
    }
}

