/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.webbeans.context.ContextualInstance;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentInstancesStore {
    private static LogProvider log = Logging.getLogProvider(DependentInstancesStore.class);
    private Map<Object, List<ContextualInstance<?>>> dependentInstances = new ConcurrentHashMap();

    public <T> void addDependentInstance(Object key, ContextualInstance<T> contextualInstance) {
        List<ContextualInstance<?>> instances = this.dependentInstances.get(key);
        if (instances == null) {
            instances = new CopyOnWriteArrayList();
            this.dependentInstances.put(key, instances);
        }
        log.trace((Object)("Registered dependent instance " + contextualInstance + " under key " + key));
        instances.add(contextualInstance);
    }

    public void destroyDependentInstances(Object key) {
        log.trace((Object)("Destroying dependent instances under key " + key));
        if (!this.dependentInstances.containsKey(key)) {
            return;
        }
        for (ContextualInstance<?> injectedInstance : this.dependentInstances.get(key)) {
            injectedInstance.destroy();
        }
        this.dependentInstances.remove(key);
    }
}

