/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.context.CreationalContext;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.ForwardingAnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjectionPoint<T>
extends ForwardingAnnotatedMethod<T>
implements AnnotatedInjectionPoint<T, Method> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final AnnotatedMethod<T> method;

    public static <T> MethodInjectionPoint<T> of(Bean<?> declaringBean, AnnotatedMethod<T> method) {
        return new MethodInjectionPoint<T>(declaringBean, method);
    }

    protected MethodInjectionPoint(Bean<?> declaringBean, AnnotatedMethod<T> method) {
        this.declaringBean = declaringBean;
        this.method = method;
    }

    @Override
    protected AnnotatedMethod<T> delegate() {
        return this.method;
    }

    public Annotation[] getAnnotations() {
        return this.delegate().getAnnotationStore().getAnnotations().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getBindings() {
        return this.delegate().getBindings();
    }

    public T invoke(Object declaringInstance, ManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.delegate().invoke(declaringInstance, this.getParameterValues(this.getParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, ManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.invoke(declaringInstance, this.getParameterValues(this.getParameters(), annotatedParameter, parameter, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeOnInstance(Object declaringInstance, ManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.delegate().invokeOnInstance(declaringInstance, this.getParameterValues(this.getParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeOnInstanceWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, ManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.invokeOnInstance(declaringInstance, this.getParameterValues(this.getParameters(), annotatedParameter, parameter, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    @Override
    public List<ParameterInjectionPoint<?>> getParameters() {
        final List<AnnotatedParameter<?>> delegate = super.getParameters();
        return new ForwardingParameterInjectionPointList(){

            @Override
            protected Bean<?> declaringBean() {
                return MethodInjectionPoint.this.declaringBean;
            }

            @Override
            protected List<? extends AnnotatedParameter<?>> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().invoke(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
    }

    protected Object[] getParameterValues(List<ParameterInjectionPoint<?>> parameters, Class<? extends Annotation> specialParam, Object specialVal, ManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<ParameterInjectionPoint<?>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint<?> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValueToInject(manager, creationalContext);
        }
        return parameterValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ForwardingParameterInjectionPointList
    extends AbstractList<ParameterInjectionPoint<?>> {
        private ForwardingParameterInjectionPointList() {
        }

        protected abstract List<? extends AnnotatedParameter<?>> delegate();

        protected abstract Bean<?> declaringBean();

        @Override
        public ParameterInjectionPoint<?> get(int index) {
            return ParameterInjectionPoint.of(MethodInjectionPoint.this.declaringBean, this.delegate().get(index));
        }

        @Override
        public int size() {
            return this.delegate().size();
        }
    }
}

