/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.NumericType;

public class MeasurementScheduleRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int scheduleId;
    private String name;
    private long interval;
    private boolean enabled;
    private DataType dataType;
    private NumericType rawNumericType;

    public MeasurementScheduleRequest(MeasurementSchedule schedule) {
        this.scheduleId = schedule.getId();
        this.name = schedule.getDefinition().getName();
        this.interval = schedule.getInterval();
        this.enabled = schedule.isEnabled();
        this.dataType = schedule.getDefinition().getDataType();
        this.rawNumericType = schedule.getDefinition().getRawNumericType();
    }

    public MeasurementScheduleRequest(int scheduleId, String name, long interval, boolean enabled, DataType dataType) {
        this(scheduleId, name, interval, enabled, dataType, null);
    }

    public MeasurementScheduleRequest(int scheduleId, String name, long interval, boolean enabled, DataType dataType, NumericType rawNumericType) {
        this.scheduleId = scheduleId;
        this.name = name;
        this.interval = interval;
        this.enabled = enabled;
        this.dataType = dataType;
        this.rawNumericType = rawNumericType;
    }

    public MeasurementScheduleRequest(MeasurementScheduleRequest scheduleRequest) {
        this.scheduleId = scheduleRequest.scheduleId;
        this.name = scheduleRequest.name;
        this.interval = scheduleRequest.interval;
        this.enabled = scheduleRequest.enabled;
        this.dataType = scheduleRequest.dataType;
        this.rawNumericType = scheduleRequest.rawNumericType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isPerMinute() {
        return this.rawNumericType != null;
    }

    public NumericType getRawNumericType() {
        return this.rawNumericType;
    }

    public String toString() {
        return "MeasurementScheduleRequest[scheduleId=" + this.scheduleId + ", name=" + this.name + ", interval=" + this.interval + ", enabled=" + this.enabled + ", dataType=" + (Object)((Object)this.dataType) + ", rawNumericType=" + (Object)((Object)this.rawNumericType) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.scheduleId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MeasurementScheduleRequest)) {
            return false;
        }
        MeasurementScheduleRequest other = (MeasurementScheduleRequest)obj;
        if (this.scheduleId != other.scheduleId) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

