/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.cache.CacheException;
import org.jboss.cache.pojo.util.PrivilegedCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instantiator {
    private static final Allocator allocator;

    public static Object newInstance(Class<?> c) throws CacheException {
        try {
            return allocator.allocate(c);
        }
        catch (Exception e) {
            throw new CacheException("failed creating instance of " + c.getName(), (Throwable)e);
        }
    }

    private static Allocator createUnsafeAllocator() {
        Allocator allocator = null;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            PrivilegedCode.setAccessible(field);
            final Object object = field.get(null);
            final Method method = clazz.getMethod("allocateInstance", Class.class);
            allocator = new Allocator(){

                @Override
                public Object allocate(Class<?> c) throws Exception {
                    try {
                        return super.allocate(c);
                    }
                    catch (Exception exception) {
                        return method.invoke(object, c);
                    }
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allocator;
    }

    private static Allocator createDefaultAllocator() {
        return new Allocator(){

            @Override
            public Object allocate(Class<?> c) throws Exception {
                try {
                    return super.allocate(c);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("A noarg constructor is required on this JVM", e);
                }
            }
        };
    }

    static {
        Allocator a = Instantiator.createUnsafeAllocator();
        allocator = a != null ? a : Instantiator.createDefaultAllocator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Allocator {
        private Allocator() {
        }

        public Object allocate(Class<?> c) throws Exception {
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            PrivilegedCode.setAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
    }
}

