/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb.handle;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.PayloadKey;
import org.jboss.logging.Logger;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.SecurityAssociation;

public class StatefulHandleImpl
implements Handle {
    private static final Logger log = Logger.getLogger(StatefulHandleImpl.class);
    static final long serialVersionUID = -6324520755180597156L;
    protected static final Method GET_EJB_OBJECT;
    private Object invokerID = null;
    public int objectName;
    public String jndiName;
    public String invokerProxyBinding;
    public Invoker invoker;
    public Object id;
    protected Hashtable jndiEnv;

    public StatefulHandleImpl() {
    }

    public StatefulHandleImpl(int objectName, String jndiName, Invoker invoker, String invokerProxyBinding, Object id, Object invokerID) {
        this.jndiName = jndiName;
        this.id = id;
        this.jndiEnv = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
        try {
            String property = System.getProperty("org.jboss.ejb.sfsb.handle.V327");
            if (property != null) {
                this.invokerProxyBinding = invokerProxyBinding;
                this.invokerID = invokerID;
                this.objectName = objectName;
                this.invoker = invoker;
            }
        }
        catch (AccessControlException ignored) {
            // empty catch block
        }
    }

    public Object getID() {
        return this.id;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.invokerProxyBinding != null) {
            try {
                return this.getEjbObjectViaInvoker();
            }
            catch (Exception e) {
                log.debug((Object)"Exception reported, try JNDI method to recover EJB object instead", (Throwable)e);
                return this.getEjbObjectViaJndi();
            }
        }
        return this.getEjbObjectViaJndi();
    }

    protected boolean isLocal() {
        return this.invokerID != null && this.invokerID.equals(Invoker.ID);
    }

    protected EJBObject getEjbObjectViaInvoker() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Using legacy invoker method for getEJBObject() invocation.");
        }
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Invocation invocation = new Invocation(null, GET_EJB_OBJECT, new Object[]{this.id}, null, sa.getPrincipal(), sa.getCredential());
        invocation.setObjectName(new Integer(this.objectName));
        invocation.setValue(InvocationKey.INVOKER_PROXY_BINDING, this.invokerProxyBinding, PayloadKey.AS_IS);
        invocation.setType(InvocationType.HOME);
        InvocationContext ctx = new InvocationContext();
        invocation.setInvocationContext(ctx);
        if (this.isLocal()) {
            return (EJBObject)InvokerInterceptor.getLocal().invoke(invocation);
        }
        return (EJBObject)this.invoker.invoke(invocation);
    }

    protected EJBObject getEjbObjectViaJndi() throws RemoteException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Using JNDI method for getEJBObject() invocation.");
            }
            InitialContext ic = null;
            ic = this.jndiEnv != null ? new InitialContext(this.jndiEnv) : new InitialContext();
            Proxy proxy = (Proxy)ic.lookup(this.jndiName);
            InvocationHandler ih = Proxy.getInvocationHandler(proxy);
            return (EJBObject)ih.invoke(proxy, GET_EJB_OBJECT, new Object[]{this.id});
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RemoteException("Error during getEJBObject", t);
        }
    }

    static {
        try {
            GET_EJB_OBJECT = Handle.class.getMethod("getEJBObject", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getCredential();
                }
            };

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }
}

