/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.ProfileAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    public static String AVATAR = "avatar";
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Identity identity;
    private String id;

    public Profile(Identity id) {
        this.identity = id;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    public String getFullName() {
        String first = (String)this.getProperty(FIRST_NAME);
        String last = (String)this.getProperty(LAST_NAME);
        String all = first != null ? first : "";
        all = all + (last != null ? " " + last : "");
        return all;
    }

    public String getAvatarImageSource(PortalContainer portalContainer) throws Exception {
        ProfileAttachment profileAttachment = (ProfileAttachment)this.getProperty(AVATAR);
        if (profileAttachment != null) {
            return "/" + portalContainer.getRestContextName() + "/jcr/" + this.getRepository(portalContainer) + "/" + profileAttachment.getWorkspace() + profileAttachment.getDataPath(portalContainer) + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    public String getAvatarImageSource() throws Exception {
        ProfileAttachment profileAttachment = (ProfileAttachment)this.getProperty(AVATAR);
        if (profileAttachment != null) {
            return "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + this.getRepository() + "/" + profileAttachment.getWorkspace() + profileAttachment.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getRepository(PortalContainer portalContainer) throws Exception {
        RepositoryService rService = (RepositoryService)portalContainer.getComponentInstanceOfType(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

