/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.RMI_IIOPResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class RMI_IIOPResource
extends J2EEResource
implements RMI_IIOPResourceMBean {
    private static Logger log = Logger.getLogger(RMI_IIOPResource.class);
    private ObjectName mService;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName corbaServiceName) {
        ObjectName lServer = null;
        try {
            lServer = mbeanServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            log.error((Object)"Could not find parent J2EEServer", (Throwable)e);
            return null;
        }
        try {
            RMI_IIOPResource rmiiiopRes = new RMI_IIOPResource(resName, lServer, corbaServiceName);
            ObjectName jsr77Name = rmiiiopRes.getObjectName();
            mbeanServer.registerMBean(rmiiiopRes, jsr77Name);
            log.debug((Object)("Created JSR-77 RMI_IIOPResource: " + resName));
            return jsr77Name;
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 RMI_IIOPResource: " + resName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            J2EEManagedObject.removeObject(mbeanServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "name=" + resName + "," + "*");
        }
        catch (Exception e) {
            log.error((Object)("Could not destroy JSR-77 RMI_IIOPResource: " + resName), (Throwable)e);
        }
    }

    public RMI_IIOPResource(String resName, ObjectName pServer, ObjectName corbaServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("RMI_IIOPResource", resName, pServer);
        log.debug((Object)("Service name: " + corbaServiceName));
        this.mService = corbaServiceName;
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.created", "RMI_IIOP Resource created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "RMI_IIOP Resource deleted");
    }

    public String toString() {
        return "RMI_IIOPResource { " + super.toString() + " } [ " + "Service name: " + this.mService + " ]";
    }
}

