/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SysViewWorkspaceInitializer
implements WorkspaceInitializer {
    public static final String RESTORE_PATH_PARAMETER = "restore-path";
    protected static final Log log = ExoLogger.getLogger((String)"jcr.WorkspaceInitializer");
    protected final String workspaceName;
    protected final DataManager dataManager;
    private final NamespaceRegistryImpl namespaceRegistry;
    private final LocationFactory locationFactory;
    private final int maxBufferSize;
    private final FileCleaner fileCleaner;
    protected String restorePath;

    public SysViewWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        this.workspaceName = config.getName();
        this.dataManager = dataManager;
        this.namespaceRegistry = namespaceRegistry;
        this.locationFactory = locationFactory;
        this.fileCleaner = new FileCleaner(false);
        this.maxBufferSize = config.getContainer().getParameterInteger("max-buffer-size", 204800);
        this.restorePath = config.getInitializer().getParameterValue(RESTORE_PATH_PARAMETER, null);
        if (this.restorePath == null) {
            throw new RepositoryConfigurationException("Workspace (" + this.workspaceName + ") RestoreIntializer should have mandatory parameter " + RESTORE_PATH_PARAMETER);
        }
    }

    public SysViewWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, String restorePath) throws RepositoryException {
        this.workspaceName = config.getName();
        this.dataManager = dataManager;
        this.namespaceRegistry = namespaceRegistry;
        this.locationFactory = locationFactory;
        this.fileCleaner = new FileCleaner(false);
        this.maxBufferSize = config.getContainer().getParameterInteger("max-buffer-size", 204800);
        this.restorePath = restorePath;
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        try {
            long start = System.currentTimeMillis();
            PlainChangesLog changes = this.read();
            TransactionChangesLog tLog = new TransactionChangesLog(changes);
            tLog.setSystemId("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID");
            this.dataManager.save(tLog);
            NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            log.info((Object)("Workspace " + this.workspaceName + " restored from file " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec"));
            return root;
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlainChangesLog read() throws XMLStreamException, FactoryConfigurationError, IOException, NamespaceException, RepositoryException, IllegalNameException {
        PlainChangesLogImpl plainChangesLogImpl;
        FileInputStream input = new FileInputStream(this.restorePath);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            String svURI = null;
            String exoURI = null;
            PlainChangesLogImpl changes = new PlainChangesLogImpl();
            Stack<SVNodeData> parents = new Stack<SVNodeData>();
            TransientItemData currentProperty = null;
            ValueWriter propertyValue = null;
            int propertyType = -1;
            block11: while (reader.hasNext()) {
                int eventCode = reader.next();
                switch (eventCode) {
                    case 1: {
                        String exoId;
                        String svName;
                        String lname = reader.getLocalName();
                        String prefix = reader.getPrefix();
                        if (!"sv".equals(prefix)) break;
                        if (svURI == null) {
                            svURI = reader.getNamespaceURI("sv");
                            exoURI = reader.getNamespaceURI("exo");
                        }
                        if ("node".equals(lname)) {
                            svName = reader.getAttributeValue(svURI, "name");
                            exoId = reader.getAttributeValue(exoURI, "id");
                            if (svName != null && exoId != null) {
                                String parentId;
                                QPath currentPath;
                                int orderNumber;
                                if (parents.size() > 0) {
                                    SVNodeData parent = (SVNodeData)parents.peek();
                                    InternalQName name = this.locationFactory.parseJCRName(svName).getInternalName();
                                    int[] chi = parent.addChildNode(name);
                                    orderNumber = chi[0];
                                    int index = chi[1];
                                    currentPath = QPath.makeChildPath(parent.getQPath(), name, index);
                                    parentId = parent.getIdentifier();
                                } else {
                                    currentPath = Constants.ROOT_PATH;
                                    parentId = null;
                                    orderNumber = 0;
                                    for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                                        String nsp = reader.getNamespacePrefix(i);
                                        try {
                                            this.namespaceRegistry.getURI(nsp);
                                            continue;
                                        }
                                        catch (NamespaceException e) {
                                            this.namespaceRegistry.registerNamespace(nsp, reader.getNamespaceURI(i));
                                        }
                                    }
                                }
                                SVNodeData currentNode = new SVNodeData(currentPath, exoId, parentId, 0, orderNumber);
                                parents.push(currentNode);
                                changes.add(new ItemState(currentNode, 1, false, Constants.ROOT_PATH, true, true));
                                break;
                            }
                            log.warn((Object)("Node skipped name=" + svName + " id=" + exoId + ". Context node " + (parents.size() > 0 ? ((SVNodeData)parents.peek()).getQPath().getAsString() : "/")));
                            break;
                        }
                        if ("property".equals(lname)) {
                            svName = reader.getAttributeValue(svURI, "name");
                            exoId = reader.getAttributeValue(exoURI, "id");
                            String svType = reader.getAttributeValue(svURI, "type");
                            if (svName != null && svType != null && exoId != null) {
                                if (parents.size() > 0) {
                                    SVNodeData parent = (SVNodeData)parents.peek();
                                    QPath currentPath = QPath.makeChildPath(parent.getQPath(), this.locationFactory.parseJCRName(svName).getInternalName());
                                    try {
                                        propertyType = PropertyType.valueFromName((String)svType);
                                    }
                                    catch (IllegalArgumentException e) {
                                        propertyType = ExtendedPropertyType.valueFromName(svType);
                                    }
                                    String exoMultivalued = reader.getAttributeValue(exoURI, "multivalued");
                                    currentProperty = new SVPropertyData(currentPath, exoId, 0, propertyType, parent.getIdentifier(), "true".equals(exoMultivalued));
                                    break;
                                }
                                log.warn((Object)("Property can'b be first name=" + svName + " type=" + svType + " id=" + exoId + ". Node should be prior. Context node " + (parents.size() > 0 ? ((SVNodeData)parents.peek()).getQPath().getAsString() : "/")));
                                break;
                            }
                            log.warn((Object)("Property skipped name=" + svName + " type=" + svType + " id=" + exoId + ". Context node " + (parents.size() > 0 ? ((SVNodeData)parents.peek()).getQPath().getAsString() : "/")));
                            break;
                        }
                        if (!"value".equals(lname) || propertyType == -1) break;
                        if (propertyType == 2) {
                            propertyValue = new BinaryValueWriter();
                            break;
                        }
                        propertyValue = new StringValueWriter();
                        break;
                    }
                    case 4: {
                        if (propertyValue == null) break;
                        propertyValue.write(reader.getText());
                        break;
                    }
                    case 2: {
                        File pfile;
                        SVNodeData parent;
                        String lname = reader.getLocalName();
                        String prefix = reader.getPrefix();
                        if (!"sv".equals(prefix)) break;
                        if ("node".equals(lname)) {
                            parent = (SVNodeData)parents.pop();
                            if (parent.getMixinTypeNames() != null) continue block11;
                            parent.setMixinTypeNames(new InternalQName[0]);
                            break;
                        }
                        if ("property".equals(lname)) {
                            if (currentProperty == null) break;
                            parent = (SVNodeData)parents.peek();
                            if (currentProperty.getQPath().getName().equals((Object)Constants.JCR_PRIMARYTYPE)) {
                                parent.setPrimartTypeName(InternalQName.parse(new String(((TransientPropertyData)currentProperty).getValues().get(0).getAsByteArray())));
                            } else if (currentProperty.getQPath().getName().equals((Object)Constants.JCR_MIXINTYPES)) {
                                InternalQName[] mixins = new InternalQName[((TransientPropertyData)currentProperty).getValues().size()];
                                for (int i = 0; i < ((TransientPropertyData)currentProperty).getValues().size(); ++i) {
                                    mixins[i] = InternalQName.parse(new String(((TransientPropertyData)currentProperty).getValues().get(i).getAsByteArray()));
                                }
                                parent.setMixinTypeNames(mixins);
                            }
                            changes.add(new ItemState(currentProperty, 1, false, Constants.ROOT_PATH, true, true));
                            propertyType = -1;
                            currentProperty = null;
                            break;
                        }
                        if (!"value".equals(lname)) break;
                        propertyValue.close();
                        TransientValueData vdata = propertyType == 7 ? new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), this.locationFactory.parseJCRName(propertyValue.getText()).getInternalName()) : (propertyType == 8 ? new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), this.locationFactory.parseJCRPath(propertyValue.getText()).getInternalPath()) : (propertyType == 5 ? new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), JCRDateFormat.parse(propertyValue.getText())) : (propertyType == 2 ? (propertyValue.isText() ? new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), propertyValue.getText()) : ((pfile = propertyValue.getFile()) != null ? new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), null, null, pfile, this.fileCleaner, this.maxBufferSize, null, true) : new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), new byte[0]))) : new TransientValueData(((TransientPropertyData)currentProperty).getValues().size(), propertyValue.getText()))));
                        ((TransientPropertyData)currentProperty).getValues().add(vdata);
                        propertyValue = null;
                        break;
                    }
                }
            }
            plainChangesLogImpl = changes;
            Object var23_29 = null;
        }
        catch (Throwable throwable) {
            Object var23_30 = null;
            ((InputStream)input).close();
            throw throwable;
        }
        ((InputStream)input).close();
        return plainChangesLogImpl;
    }

    public void start() {
        this.fileCleaner.start();
    }

    public void stop() {
    }

    public boolean isWorkspaceInitialized() {
        try {
            return this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000") != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected class SVPropertyData
    extends TransientPropertyData {
        SVPropertyData(QPath path, String identifier, int version, int type, String parentIdentifier, boolean multivalued) {
            super(path, identifier, version, type, parentIdentifier, multivalued);
            this.values = new ArrayList();
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }
    }

    protected class SVNodeData
    extends TransientNodeData {
        int orderNumber;
        HashMap<InternalQName, Integer> childNodesMap;

        SVNodeData(QPath path, String identifier, String parentIdentifier, int version, int orderNum) {
            super(path, identifier, version, null, null, orderNum, parentIdentifier, null);
            this.orderNumber = 0;
            this.childNodesMap = new HashMap();
        }

        void setPrimartTypeName(InternalQName primaryTypeName) {
            this.primaryTypeName = primaryTypeName;
        }

        public void setMixinTypeNames(InternalQName[] mixinTypeNames) {
            this.mixinTypeNames = mixinTypeNames;
        }

        int[] addChildNode(InternalQName childName) {
            Integer count = this.childNodesMap.get((Object)childName);
            if (count != null) {
                this.childNodesMap.put(childName, count + 1);
            } else {
                this.childNodesMap.put(childName, 1);
            }
            int index = this.childNodesMap.get((Object)childName);
            return new int[]{this.orderNumber++, index};
        }
    }

    protected class Base64Decoder
    extends Base64.Decoder {
        private File tmpFile;
        private OutputStream buff;

        Base64Decoder() {
            super(SysViewWorkspaceInitializer.this.maxBufferSize);
        }

        protected void writeBuffer(byte[] buffer, int offset, int len) throws IOException {
            if (this.buff == null) {
                if (buffer.length >= SysViewWorkspaceInitializer.this.maxBufferSize) {
                    this.tmpFile = File.createTempFile("jcrrestorewi", ".tmp");
                    this.buff = new FileOutputStream(this.tmpFile);
                } else {
                    this.buff = new TempOutputStream();
                }
            } else if (this.tmpFile == null && ((TempOutputStream)this.buff).getSize() + buffer.length > SysViewWorkspaceInitializer.this.maxBufferSize) {
                this.tmpFile = File.createTempFile("jcrrestorewi", ".tmp");
                FileOutputStream fout = new FileOutputStream(this.tmpFile);
                fout.write(((TempOutputStream)this.buff).getBuffer());
                this.buff.close();
                this.buff = fout;
            }
            this.buff.write(buffer, offset, len);
        }

        void close() throws IOException {
            super.flush();
            if (this.buff != null) {
                this.buff.close();
            }
        }

        File getFile() throws IOException {
            return this.tmpFile;
        }

        byte[] getByteArray() throws IOException {
            if (this.buff != null) {
                return ((TempOutputStream)this.buff).getBuffer();
            }
            return null;
        }

        boolean isBuffered() {
            return this.tmpFile != null;
        }
    }

    protected class BinaryValueWriter
    extends ValueWriter {
        final Base64Decoder decoder;

        protected BinaryValueWriter() {
            this.decoder = new Base64Decoder();
        }

        void close() throws IOException {
            this.decoder.flush();
        }

        void write(String text) throws IOException {
            this.decoder.write(text.toCharArray(), 0, text.length());
        }

        File getFile() throws IOException {
            return this.decoder.getFile();
        }

        String getText() throws IOException {
            return new String(this.decoder.getByteArray() != null ? this.decoder.getByteArray() : new byte[]{});
        }

        boolean isText() {
            return !this.decoder.isBuffered();
        }
    }

    protected class StringValueWriter
    extends ValueWriter {
        final StringBuilder string;

        protected StringValueWriter() {
            this.string = new StringBuilder();
        }

        void close() {
        }

        void write(String text) {
            this.string.append(text);
        }

        boolean isText() {
            return true;
        }

        File getFile() throws IOException {
            throw new IOException("StringValueWriter.getInputStream() not supported. Use getText() instead.");
        }

        String getText() {
            return this.string.toString();
        }
    }

    protected abstract class ValueWriter {
        protected ValueWriter() {
        }

        abstract void close() throws IOException;

        abstract void write(String var1) throws IOException;

        abstract boolean isText();

        abstract File getFile() throws IOException;

        abstract String getText() throws IOException;
    }

    protected class TempOutputStream
    extends ByteArrayOutputStream {
        protected TempOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getSize() {
            return this.buf.length;
        }

        public void close() {
            this.buf = null;
        }
    }
}

