/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataValidator {
    private final Log log = ExoLogger.getLogger(NodeTypeDataValidator.class);
    protected final NodeTypeRepository hierarchy;

    public NodeTypeDataValidator(NodeTypeRepository hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void validateNodeType(List<NodeTypeData> nodeTypeDataList) throws RepositoryException {
        for (NodeTypeData nodeTypeData : nodeTypeDataList) {
            this.validateNodeType(nodeTypeData);
        }
        this.checkCyclicDependencies(nodeTypeDataList);
    }

    private void checkCyclicDependencies(List<NodeTypeData> nodeTypeDataList) throws RepositoryException {
        HashSet<InternalQName> unresolvedDependecies = new HashSet<InternalQName>();
        HashSet<InternalQName> resolvedDependecies = new HashSet<InternalQName>();
        for (NodeTypeData nodeTypeData : nodeTypeDataList) {
            int i;
            resolvedDependecies.add(nodeTypeData.getName());
            unresolvedDependecies.remove((Object)nodeTypeData.getName());
            for (i = 0; i < nodeTypeData.getDeclaredSupertypeNames().length; ++i) {
                InternalQName superName = nodeTypeData.getDeclaredSupertypeNames()[i];
                if (this.hierarchy.getNodeType(superName) != null || resolvedDependecies.contains((Object)superName)) continue;
                unresolvedDependecies.add(superName);
            }
            for (i = 0; i < nodeTypeData.getDeclaredChildNodeDefinitions().length; ++i) {
                NodeDefinitionData childnodeDefinitionData = nodeTypeData.getDeclaredChildNodeDefinitions()[i];
                for (int j = 0; j < childnodeDefinitionData.getRequiredPrimaryTypes().length; ++j) {
                    InternalQName requiredPrimaryTypeName = childnodeDefinitionData.getRequiredPrimaryTypes()[j];
                    if (this.hierarchy.getNodeType(requiredPrimaryTypeName) != null || resolvedDependecies.contains((Object)requiredPrimaryTypeName)) continue;
                    unresolvedDependecies.add(requiredPrimaryTypeName);
                }
                if (childnodeDefinitionData.getDefaultPrimaryType() == null || this.hierarchy.getNodeType(childnodeDefinitionData.getDefaultPrimaryType()) != null || resolvedDependecies.contains((Object)childnodeDefinitionData.getDefaultPrimaryType())) continue;
                unresolvedDependecies.add(childnodeDefinitionData.getDefaultPrimaryType());
            }
        }
        if (unresolvedDependecies.size() > 0) {
            String msg = "Fail. Unresolved cyclic dependecy for :";
            for (InternalQName internalQName : resolvedDependecies) {
                msg = msg + " " + internalQName.getAsString();
            }
            msg = msg + " Unresolved ";
            for (InternalQName internalQName : unresolvedDependecies) {
                msg = msg + " " + internalQName.getAsString();
            }
            throw new RepositoryException(msg);
        }
    }

    private void validateNodeType(NodeTypeData nodeType) throws RepositoryException {
        int i;
        if (nodeType == null) {
            throw new RepositoryException("NodeType object " + nodeType + " is null");
        }
        for (i = 0; i < nodeType.getDeclaredSupertypeNames().length; ++i) {
            if (nodeType.getName().equals((Object)Constants.NT_BASE) || !nodeType.getName().equals((Object)nodeType.getDeclaredSupertypeNames()[i])) continue;
            throw new RepositoryException("Invalid super type name" + nodeType.getDeclaredSupertypeNames()[i].getAsString());
        }
        for (i = 0; i < nodeType.getDeclaredPropertyDefinitions().length; ++i) {
            if (nodeType.getDeclaredPropertyDefinitions()[i].getDeclaringNodeType().equals((Object)nodeType.getName())) continue;
            throw new RepositoryException("Invalid declared  node type in property definitions with name " + nodeType.getDeclaredPropertyDefinitions()[i].getName().getAsString() + " not registred");
        }
        for (i = 0; i < nodeType.getDeclaredChildNodeDefinitions().length; ++i) {
            if (nodeType.getDeclaredChildNodeDefinitions()[i].getDeclaringNodeType().equals((Object)nodeType.getName())) continue;
            throw new RepositoryException("Invalid declared  node type in child node definitions with name " + nodeType.getDeclaredChildNodeDefinitions()[i].getName().getAsString() + " not registred");
        }
        if (nodeType.getName() == null) {
            throw new RepositoryException("NodeType implementation class " + nodeType.getClass().getName() + " is not supported in this method");
        }
    }
}

