/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class TransientItemData
implements ItemData,
Externalizable {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.TransientItemData");
    protected String identifier;
    protected String parentIdentifier;
    protected int persistedVersion;
    protected QPath qpath;
    private int NOT_NULL_VALUE = 1;
    private int NULL_VALUE = -1;

    TransientItemData() {
    }

    TransientItemData(QPath path, String identifier, int version, String parentIdentifier) {
        this.parentIdentifier = parentIdentifier != null ? parentIdentifier : null;
        this.identifier = identifier;
        this.qpath = path;
        this.persistedVersion = version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ItemData) {
            return this.getIdentifier().hashCode() == ((ItemData)obj).getIdentifier().hashCode();
        }
        return false;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public int getPersistedVersion() {
        return this.persistedVersion;
    }

    public InternalQName getQName() {
        return this.qpath.getName();
    }

    public QPath getQPath() {
        return this.qpath;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        try {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String sQPath = new String(buf, "UTF-8");
            this.qpath = QPath.parse(sQPath);
        }
        catch (IllegalPathException e) {
            throw new IOException("Deserialization error. " + (Object)((Object)e)){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.identifier = new String(buf);
        int isNull = in.readInt();
        if (isNull == this.NOT_NULL_VALUE) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.parentIdentifier = new String(buf);
        }
        this.persistedVersion = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.qpath.getAsString().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        out.writeInt(this.identifier.getBytes().length);
        out.write(this.identifier.getBytes());
        if (this.parentIdentifier != null) {
            out.writeInt(this.NOT_NULL_VALUE);
            out.writeInt(this.parentIdentifier.getBytes().length);
            out.write(this.parentIdentifier.getBytes());
        } else {
            out.writeInt(this.NULL_VALUE);
        }
        out.writeInt(this.persistedVersion);
    }
}

