/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.oasis.wsrp.v1.AccessDenied;
import org.oasis.wsrp.v1.AccessDeniedFault;
import org.oasis.wsrp.v1.Fault;
import org.oasis.wsrp.v1.InconsistentParameters;
import org.oasis.wsrp.v1.InconsistentParametersFault;
import org.oasis.wsrp.v1.InvalidCookie;
import org.oasis.wsrp.v1.InvalidCookieFault;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidHandleFault;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.InvalidRegistrationFault;
import org.oasis.wsrp.v1.InvalidSession;
import org.oasis.wsrp.v1.InvalidSessionFault;
import org.oasis.wsrp.v1.InvalidUserCategory;
import org.oasis.wsrp.v1.InvalidUserCategoryFault;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.MissingParametersFault;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.OperationFailedFault;
import org.oasis.wsrp.v1.PortletStateChangeRequired;
import org.oasis.wsrp.v1.PortletStateChangeRequiredFault;
import org.oasis.wsrp.v1.UnsupportedLocale;
import org.oasis.wsrp.v1.UnsupportedLocaleFault;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMimeTypeFault;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedModeFault;
import org.oasis.wsrp.v1.UnsupportedWindowState;
import org.oasis.wsrp.v1.UnsupportedWindowStateFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPExceptionFactory {
    private static final Logger log = LoggerFactory.getLogger(WSRPExceptionFactory.class);
    private static final String NS = "urn:oasis:names:tc:wsrp:v1:types";
    public static final String ACCESS_DENIED = "AccessDenied";
    public static final String INCONSISTENT_PARAMETERS = "InconsistentParameters";
    public static final String INVALID_REGISTRATION = "InvalidRegistration";
    public static final String INVALID_COOKIE = "InvalidCookie";
    public static final String INVALID_HANDLE = "InvalidHandle";
    public static final String INVALID_SESSION = "InvalidSession";
    public static final String INVALID_USER_CATEGORY = "InvalidUserCategory";
    public static final String MISSING_PARAMETERS = "MissingParameters";
    public static final String OPERATION_FAILED = "OperationFailed";
    public static final String PORTLET_STATE_CHANGE_REQUIRED = "PortletStateChangeRequired";
    public static final String UNSUPPORTED_LOCALE = "UnsupportedLocale";
    public static final String UNSUPPORTED_MIME_TYPE = "UnsupportedMimeType";
    public static final String UNSUPPORTED_MODE = "UnsupportedMode";
    public static final String UNSUPPORTED_WINDOW_STATE = "UnsupportedWindowState";
    private static final String NS_PREFIX = "wsrp";
    private static final Map<String, ExceptionFactory<? extends Exception, ? extends Fault>> errorCodeToExceptions = new HashMap<String, ExceptionFactory<? extends Exception, ? extends Fault>>(17);

    private WSRPExceptionFactory() {
    }

    public static void throwMissingParametersIfValueIsMissing(Object valueToCheck, String valueName, String context) throws MissingParameters {
        if (valueToCheck == null) {
            throw new MissingParameters("Missing required " + valueName + (context != null ? " in " + context : ""), new MissingParametersFault());
        }
    }

    public static void throwOperationFailedIfValueIsMissing(Object valueToCheck, String valueName) throws OperationFailed {
        if (valueToCheck == null) {
            throw new OperationFailed("Missing required " + valueName, new OperationFailedFault());
        }
    }

    public static <E extends Exception, F extends Fault> E throwWSException(String errorCode, String message, Throwable cause) throws E {
        ExceptionFactory<? extends Exception, ? extends Fault> exceptionFactory = errorCodeToExceptions.get(errorCode);
        if (exceptionFactory == null) {
            throw new IllegalArgumentException("Unknown error code: " + errorCode);
        }
        throw exceptionFactory.newInstance(message, cause);
    }

    static {
        try {
            errorCodeToExceptions.put(ACCESS_DENIED, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<AccessDenied, AccessDeniedFault>(){});
            errorCodeToExceptions.put(INCONSISTENT_PARAMETERS, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InconsistentParameters, InconsistentParametersFault>(){});
            errorCodeToExceptions.put(INVALID_COOKIE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InvalidCookie, InvalidCookieFault>(){});
            errorCodeToExceptions.put(INVALID_HANDLE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InvalidHandle, InvalidHandleFault>(){});
            errorCodeToExceptions.put(INVALID_REGISTRATION, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InvalidRegistration, InvalidRegistrationFault>(){});
            errorCodeToExceptions.put(INVALID_SESSION, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InvalidSession, InvalidSessionFault>(){});
            errorCodeToExceptions.put(INVALID_USER_CATEGORY, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<InvalidUserCategory, InvalidUserCategoryFault>(){});
            errorCodeToExceptions.put(MISSING_PARAMETERS, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<MissingParameters, MissingParametersFault>(){});
            errorCodeToExceptions.put(OPERATION_FAILED, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<OperationFailed, OperationFailedFault>(){});
            errorCodeToExceptions.put(PORTLET_STATE_CHANGE_REQUIRED, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<PortletStateChangeRequired, PortletStateChangeRequiredFault>(){});
            errorCodeToExceptions.put(UNSUPPORTED_LOCALE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<UnsupportedLocale, UnsupportedLocaleFault>(){});
            errorCodeToExceptions.put(UNSUPPORTED_MIME_TYPE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<UnsupportedMimeType, UnsupportedMimeTypeFault>(){});
            errorCodeToExceptions.put(UNSUPPORTED_MODE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<UnsupportedMode, UnsupportedModeFault>(){});
            errorCodeToExceptions.put(UNSUPPORTED_WINDOW_STATE, (ExceptionFactory<? extends Exception, ? extends Fault>)new ExceptionFactory<UnsupportedWindowState, UnsupportedWindowStateFault>(){});
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing WSRPExceptionFactory", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ExceptionFactory<E extends Exception, F extends Fault> {
        private final Constructor<E> exceptionConstructor;
        private final Fault fault;

        public ExceptionFactory() throws NoSuchMethodException, IllegalAccessException, InstantiationException {
            ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
            Class exceptionClass = (Class)pt.getActualTypeArguments()[0];
            Class faultClass = (Class)pt.getActualTypeArguments()[1];
            this.exceptionConstructor = exceptionClass.getConstructor(String.class, faultClass, Throwable.class);
            this.fault = (Fault)faultClass.newInstance();
        }

        public E newInstance(String message, Throwable cause) {
            try {
                return (E)((Exception)this.exceptionConstructor.newInstance(message, this.fault, cause));
            }
            catch (Exception e) {
                log.debug("Couldn't instantiate Exception associated with " + this.fault.getClass().getSimpleName() + ", message: " + message + ", cause: " + cause);
                return null;
            }
        }
    }
}

