/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.lifecycle;

import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.spi.ProfileLifeCycleEvent;
import org.exoplatform.social.core.identity.spi.ProfileListener;
import org.exoplatform.social.lifecycle.AbstractLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileLifeCycle
extends AbstractLifeCycle<ProfileListener, ProfileLifeCycleEvent> {
    protected void dispatchEvent(ProfileListener listener, ProfileLifeCycleEvent event) {
        switch (event.getType()) {
            case AVATAR_UPDATED: {
                listener.avatarUpdated(event);
                break;
            }
            case BASIC_UPDATED: {
                listener.basicInfoUpdated(event);
                break;
            }
            case CONTACT_UPDATED: {
                listener.contactSectionUpdated(event);
                break;
            }
            case EXPERIENCE_UPDATED: {
                listener.experienceSectionUpdated(event);
                break;
            }
            case HEADER_UPDATED: {
                listener.headerSectionUpdated(event);
                break;
            }
        }
    }

    public void avatarUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.AVATAR_UPDATED, username, profile));
    }

    public void basicUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.BASIC_UPDATED, username, profile));
    }

    public void contactUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, username, profile));
    }

    public void experienceUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.EXPERIENCE_UPDATED, username, profile));
    }

    public void headerUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.HEADER_UPDATED, username, profile));
    }
}

