/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space;

import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class JCRSessionManager {
    private static final ThreadLocal<Session> currentSession = new ThreadLocal();
    String workspaceName = "portal-system";
    String repositoryName = "repository";
    RepositoryService repositoryService;

    public JCRSessionManager(String repository, String workspace, RepositoryService repositoryService) {
        this.workspaceName = workspace;
        this.repositoryName = repository;
        this.repositoryService = repositoryService;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public static Session getCurrentSession() {
        return currentSession.get();
    }

    public Session getSession(SessionProvider sessionProvider) {
        Session session = null;
        try {
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryName);
            session = sessionProvider.getSession(this.workspaceName, repository);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return session;
    }

    public Session openSession() {
        Session session = currentSession.get();
        if (session != null) {
            throw new IllegalStateException("A session is already opened.");
        }
        session = this.createSession();
        currentSession.set(session);
        return session;
    }

    public Session getOrOpenSession() {
        Session session = JCRSessionManager.getCurrentSession();
        if (session == null) {
            session = this.openSession();
        }
        return session;
    }

    private Session createSession() {
        Session session = null;
        try {
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryName);
            session = repository.getSystemSession(this.workspaceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return session;
    }

    public boolean closeSession() {
        return this.closeSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSession(boolean save) {
        Session session = currentSession.get();
        if (session == null) {
            return false;
        }
        currentSession.set(null);
        try {
            if (save) {
                session.save();
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
        return true;
    }
}

