/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

@Singleton
public class BasicHttpFetcher
implements HttpFetcher {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_MAX_OBJECT_SIZE = 0x100000;
    private volatile int connectionTimeoutMs;

    public BasicHttpFetcher(int maxObjSize, int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    @Inject
    public BasicHttpFetcher() {
        this(0x100000, 5000);
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    private HttpResponse makeResponse(HttpMethod httpMethod, int responseCode) throws IOException {
        HashMap headers = Maps.newHashMap();
        if (httpMethod.getResponseHeaders() != null) {
            for (Header h : httpMethod.getResponseHeaders()) {
                headers.put(h.getName(), h.getValue());
            }
        }
        headers.remove(null);
        InputStream responseBodyStream = null;
        try {
            responseBodyStream = httpMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (responseBodyStream == null) {
            responseBodyStream = new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        String encoding = (String)headers.get("Content-Encoding");
        InputStream is = responseBodyStream;
        if (encoding == null) {
            is = responseBodyStream;
        } else if (encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(responseBodyStream);
        } else if (encoding.equalsIgnoreCase("deflate")) {
            Inflater inflater = new Inflater(true);
            is = new InflaterInputStream(responseBodyStream, inflater);
        }
        byte[] body = IOUtils.toByteArray((InputStream)is);
        return new HttpResponseBuilder().setHttpStatusCode(responseCode).setResponse(body).addHeaders(headers).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse fetch(HttpRequest request) {
        HttpResponse httpResponse;
        Object httpMethod;
        HttpClient httpClient = new HttpClient();
        String methodType = request.getMethod();
        String requestUri = request.getUri().toString();
        Proxy proxy = ProxySelector.getDefault().select(request.getUri().toJavaUri()).get(0);
        if (proxy != Proxy.NO_PROXY) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            httpClient.getHostConfiguration().setProxy(address.getHostName(), address.getPort());
        }
        if ("POST".equals(methodType) || "PUT".equals(methodType)) {
            PostMethod enclosingMethod;
            Object object = enclosingMethod = "POST".equals(methodType) ? new PostMethod(requestUri) : new PutMethod(requestUri);
            if (request.getPostBodyLength() > 0) {
                enclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(request.getPostBody()));
                enclosingMethod.setRequestHeader("Content-Length", String.valueOf(request.getPostBodyLength()));
            }
            httpMethod = enclosingMethod;
        } else {
            httpMethod = "DELETE".equals(methodType) ? new DeleteMethod(requestUri) : new GetMethod(requestUri);
        }
        httpMethod.setFollowRedirects(false);
        httpMethod.getParams().setSoTimeout(this.connectionTimeoutMs);
        httpMethod.setRequestHeader("Accept-Encoding", "gzip, deflate");
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            httpMethod.setRequestHeader(entry.getKey(), StringUtils.join((Collection)entry.getValue(), (char)','));
        }
        try {
            Header header;
            int statusCode = httpClient.executeMethod((HttpMethod)httpMethod);
            if (request.getFollowRedirects() && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307) && (header = httpMethod.getResponseHeader("location")) != null) {
                String redirectUri = header.getValue();
                if (redirectUri == null || redirectUri.equals("")) {
                    redirectUri = "/";
                }
                httpMethod.releaseConnection();
                httpMethod = new GetMethod(redirectUri);
                statusCode = httpClient.executeMethod((HttpMethod)httpMethod);
            }
            httpResponse = this.makeResponse((HttpMethod)httpMethod, statusCode);
            return httpResponse;
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException || e instanceof SocketException) {
                httpResponse = HttpResponse.timeout();
                return httpResponse;
            }
            httpResponse = HttpResponse.error();
            return httpResponse;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }
}

