/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityTokenDecoder;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.config.ContainerConfig;
import org.exoplatform.social.opensocial.ExoBlobCrypterSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ExoBlobCrypterSecurityDecoder
extends BlobCrypterSecurityTokenDecoder {
    @Inject
    public ExoBlobCrypterSecurityDecoder(ContainerConfig config) {
        super(config);
    }

    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        String token = tokenParameters.get("token");
        if (token == null || token.trim().length() == 0) {
            return new AnonymousSecurityToken();
        }
        String[] fields = token.split(":");
        if (fields.length != 2) {
            throw new SecurityTokenException("Invalid security token " + token);
        }
        String container = fields[0];
        BlobCrypter crypter = (BlobCrypter)this.crypters.get(container);
        if (crypter == null) {
            throw new SecurityTokenException("Unknown container " + token);
        }
        String domain = (String)this.domains.get(container);
        String activeUrl = tokenParameters.get("activeUrl");
        String crypted = fields[1];
        try {
            return ExoBlobCrypterSecurityToken.decrypt(crypter, container, domain, crypted, activeUrl);
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException((Exception)((Object)e));
        }
    }
}

