/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.spi;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.model.FilterOperation;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;
import org.exoplatform.social.jcr.QuerySpec;
import org.exoplatform.social.opensocial.ExoBlobCrypterSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoService {
    protected Set<Identity> getIdSet(UserId user, GroupId group, SecurityToken token) throws Exception {
        if (token instanceof AnonymousSecurityToken) {
            throw new Exception(Integer.toString(403));
        }
        String userId = user.getUserId(token);
        Identity id = this.getIdentity(userId, token);
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        if (group == null) {
            returnVal.add(id);
        } else {
            switch (group.getType()) {
                case all: 
                case friends: 
                case groupId: {
                    returnVal.addAll(this.getFriendsList(id, token));
                    break;
                }
                case self: {
                    returnVal.add(id);
                }
            }
        }
        return returnVal;
    }

    protected List<Identity> getFriendsList(Identity id, SecurityToken token) throws Exception {
        PortalContainer pc = this.getPortalContainer(token);
        RelationshipManager rm = (RelationshipManager)pc.getComponentInstanceOfType(RelationshipManager.class);
        List rels = rm.getContacts(id);
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (Relationship rel : rels) {
            if (rel.getIdentity1().getId().equals(id.getId())) {
                ids.add(rel.getIdentity2());
                continue;
            }
            ids.add(rel.getIdentity1());
        }
        return ids;
    }

    protected Set<Identity> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) throws Exception {
        if (token instanceof AnonymousSecurityToken) {
            throw new Exception(Integer.toString(403));
        }
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    protected Identity getIdentity(String id, boolean loadProfile, SecurityToken st) throws Exception {
        PortalContainer pc = this.getPortalContainer(st);
        IdentityManager im = (IdentityManager)pc.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = im.getIdentity(id, loadProfile);
        if (identity == null) {
            throw new Exception("\n\n\n can't find identity \n\n\n");
        }
        return identity;
    }

    protected Identity getIdentity(String id, SecurityToken st) throws Exception {
        return this.getIdentity(id, false, st);
    }

    protected PortalContainer getPortalContainer(SecurityToken st) {
        String portalName = PortalContainer.getCurrentPortalContainerName();
        if (st instanceof ExoBlobCrypterSecurityToken) {
            portalName = ((ExoBlobCrypterSecurityToken)st).getPortalContainer();
        }
        return (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
    }

    protected String getHost(SecurityToken st) {
        String host = null;
        if (st instanceof ExoBlobCrypterSecurityToken) {
            host = ((ExoBlobCrypterSecurityToken)st).getHostName();
        }
        return host;
    }

    protected QuerySpec toQuerySpec(CollectionOptions options) {
        QuerySpec.Operation operation;
        QuerySpec query = new QuerySpec();
        query.setFirst(options.getFirst());
        query.setMax(options.getMax());
        if (options.getFilter() != null && (operation = this.toOperation(options.getFilterOperation())) != null) {
            query.addCondition(options.getFilter(), operation, options.getFilterValue());
        }
        if (options.getSortBy() != null) {
            QuerySpec.SortOrder sortOrder = options.getSortOrder() == SortOrder.ascending ? QuerySpec.SortOrder.asc : QuerySpec.SortOrder.desc;
            query.addSort(options.getSortBy(), sortOrder);
        }
        if (options.getUpdatedSince() != null) {
            query.addCondition("updated", QuerySpec.Operation.greaterThan, "" + options.getUpdatedSince().getTime());
        }
        return query;
    }

    private QuerySpec.Operation toOperation(FilterOperation filterOperation) {
        try {
            QuerySpec.Operation.valueOf(QuerySpec.Operation.class, (String)filterOperation.name());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

