/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.people;

import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.lifecycle.RelationshipListenerPlugin;
import org.exoplatform.social.relationship.spi.RelationshipEvent;

public class RelationshipPublisher
extends RelationshipListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(RelationshipPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public RelationshipPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity id1 = relationship.getIdentity1();
            this.reloadIfNeeded(id1);
            Identity id2 = relationship.getIdentity2();
            this.reloadIfNeeded(id2);
            String user1 = id1.getProfile().getFullName();
            String user2 = id2.getProfile().getFullName();
            Activity activity = new Activity(id1.getId(), "exosocial:people", user1, user1 + " is now connected to " + user2);
            activity.setTitleId("RELATION_CONFIRMED");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Requester", user1);
            params.put("Accepter", user2);
            activity.setTemplateParams(params);
            this.activityManager.saveActivity(activity);
            Activity activity2 = new Activity(id2.getId(), "exosocial:people", user2, user2 + " is now connected to " + user1);
            activity2.setTitleId("RELATION_CONFIRMED");
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put("Requester", user2);
            params2.put("Accepter", user1);
            activity2.setTemplateParams(params);
            this.activityManager.saveActivity(activity2);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + event + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity identity) throws Exception {
        if (identity.getId() == null || identity.getProfile().getFullName().length() == 0) {
            identity = this.identityManager.getIdentity(identity.getGlobalId().toString(), true);
        }
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
    }
}

