/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class CipherSocket
extends Socket {
    private Cipher cipher;
    private Socket delegate;
    String algorithm;
    SecretKey key;

    public CipherSocket(String host, int port, String algorithm, SecretKey key) throws IOException {
        super(host, port);
        this.algorithm = algorithm;
        this.key = key;
    }

    public CipherSocket(Socket delegate, String algorithm, SecretKey key) throws IOException {
        this.delegate = delegate;
        this.algorithm = algorithm;
        this.key = key;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.delegate == null ? super.getInputStream() : this.delegate.getInputStream();
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
            int size = cipher.getBlockSize();
            byte[] tmp = new byte[size];
            Arrays.fill(tmp, (byte)15);
            IvParameterSpec iv = new IvParameterSpec(tmp);
            cipher.init(2, (Key)this.key, iv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed to init cipher: " + e.getMessage());
        }
        CipherInputStream cis = new CipherInputStream(is, cipher);
        return cis;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream os = this.delegate == null ? super.getOutputStream() : this.delegate.getOutputStream();
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
            int size = cipher.getBlockSize();
            byte[] tmp = new byte[size];
            Arrays.fill(tmp, (byte)15);
            IvParameterSpec iv = new IvParameterSpec(tmp);
            cipher.init(1, (Key)this.key, iv);
        }
        catch (Exception e) {
            throw new IOException("Failed to init cipher: " + e.getMessage());
        }
        CipherOutputStream cos = new CipherOutputStream(os, cipher);
        return cos;
    }
}

