/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Util {
    public static Logger log = Logger.getLogger(Util.class);

    public static String guidToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (!(o instanceof String)) {
            return o.toString();
        }
        String s = (String)o;
        int idx = s.lastIndexOf(45, s.lastIndexOf(45) - 1);
        if (idx < 0) {
            return s;
        }
        return "...-" + s.substring(idx + 1);
    }

    public static String transactionIsolationToString(int level) {
        return level == 0 ? "NONE" : (level == 1 ? "READ_UNCOMMITTED" : (level == 2 ? "READ_COMMITTED" : (level == 4 ? "REPEATABLE_READ" : (level == 8 ? "SERIALIZABLE" : "UNKNOWN"))));
    }

    public static Element stringToElement(String s) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(new StringReader(s)));
        return doc.getDocumentElement();
    }

    public static String deliveryMode(int m) {
        if (m == 1) {
            return "NON_PERSISTENT";
        }
        if (m == 2) {
            return "PERSISTENT";
        }
        return "UNKNOWN";
    }

    public static String acknowledgmentMode(int ack) {
        if (ack == 1) {
            return "AUTO_ACKNOWLEDGE";
        }
        if (ack == 2) {
            return "CLIENT_ACKNOWLEDGE";
        }
        if (ack == 3) {
            return "DUPS_OK_ACKNOWLEDGE";
        }
        if (ack == 0) {
            return "SESSION_TRANSACTED";
        }
        return "UNKNOWN";
    }

    private Util() {
    }
}

