/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.jaxrpcmapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;

public class ExceptionMapping
implements Serializable {
    private static final long serialVersionUID = 2964098233936811614L;
    private JavaWsdlMapping javaWsdlMapping;
    private String exceptionType;
    private QName wsdlMessage;
    private ArrayList constructorParameterOrder = new ArrayList();

    public ExceptionMapping(JavaWsdlMapping javaWsdlMapping) {
        this.javaWsdlMapping = javaWsdlMapping;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public QName getWsdlMessage() {
        return this.wsdlMessage;
    }

    public void setWsdlMessage(QName wsdlMessage) {
        this.wsdlMessage = wsdlMessage;
    }

    public String[] getConstructorParameterOrder() {
        String[] arr = new String[this.constructorParameterOrder.size()];
        this.constructorParameterOrder.toArray(arr);
        return arr;
    }

    public void addConstructorParameter(String elementName) {
        this.constructorParameterOrder.add(elementName);
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append("<exception-mapping>");
        sb.append("<exception-type>").append(this.exceptionType).append("</exception-type>");
        sb.append("<wsdl-message xmlns:exMsgNS='").append(this.wsdlMessage.getNamespaceURI()).append("'>");
        sb.append("exMsgNS").append(":").append(this.wsdlMessage.getLocalPart());
        sb.append("</wsdl-message>");
        if (this.constructorParameterOrder.size() > 0) {
            sb.append("<constructor-parameter-order>");
            Iterator i = this.constructorParameterOrder.iterator();
            while (i.hasNext()) {
                sb.append("<element-name>").append(i.next()).append("</element-name>");
            }
            sb.append("</constructor-parameter-order>");
        }
        sb.append("</exception-mapping>");
        return sb.toString();
    }
}

