/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.juddi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.registry.RegistryServlet;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.xml.XMLUtils;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JUDDIServlet
extends HttpServlet {
    private static final long serialVersionUID = 8768916717023791095L;
    private static DocumentBuilder docBuilder = null;
    private static HandlerMaker maker = HandlerMaker.getInstance();
    private static Logger log = Logger.getLogger((Class)JUDDIServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setHeader("Allow", "POST");
        res.sendError(405, "The request method 'GET' is not allowed by UDDI API.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/xml; charset=utf-8");
        SOAPMessage soapReq = null;
        SOAPMessage soapRes = null;
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            soapReq = msgFactory.createMessage(null, (InputStream)req.getInputStream());
            soapRes = msgFactory.createMessage();
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                soapReq.writeTo((OutputStream)bs);
                log.debug((Object)("Request received::" + bs.toString()));
            }
            SOAPBody soapReqBody = soapReq.getSOAPBody();
            Iterator it = soapReqBody.getChildElements();
            Node uddiReq = null;
            while (uddiReq == null && it.hasNext()) {
                Object current = it.next();
                if (!(current instanceof Element)) continue;
                uddiReq = (Element)current;
            }
            if (uddiReq == null) {
                throw new FatalErrorException("A UDDI request was not found in the SOAP message.");
            }
            String function = uddiReq.getLocalName();
            if (function == null || function.trim().length() == 0) {
                throw new FatalErrorException("The name of the UDDI request could not be identified.");
            }
            AbstractHandler requestHandler = maker.lookup(function);
            if (requestHandler == null) {
                throw new UnsupportedException("The UDDI request type specified is unknown: " + function);
            }
            String generic = uddiReq.getAttribute("generic");
            if (generic == null) {
                throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + function + " (The " + "'generic' attribute must be present)");
            }
            if (!generic.equals("2.0")) {
                throw new UnsupportedException("Currently only UDDI v2 requests are supported. The generic attribute value received was: " + generic);
            }
            RegistryObject uddiReqObj = requestHandler.unmarshal((Element)uddiReq);
            if (uddiReqObj == null) {
                throw new FatalErrorException("Uddi Request is null");
            }
            RegistryObject uddiResObj = null;
            RegistryEngine registry = RegistryServlet.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is currently unavailable.");
            }
            uddiResObj = registry.execute(uddiReqObj);
            AbstractHandler responseHandler = maker.lookup(uddiResObj.getClass().getName());
            if (responseHandler == null) {
                throw new FatalErrorException("The response object type is unknown: " + uddiResObj.getClass().getName());
            }
            DocumentBuilder docBuilder = this.getDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element element = document.createElement("temp");
            responseHandler.marshal(uddiResObj, element);
            log.debug((Object)"Response that will be sent:");
            log.debug((Object)XMLUtils.toString((Element)((Element)element.getFirstChild())));
            Element el = (Element)element.getFirstChild();
            soapRes = this.createSOAPMessage(el);
        }
        catch (Exception ex) {
            String faultCode = null;
            String faultString = null;
            String faultActor = null;
            String errno = null;
            String errCode = null;
            String errMsg = null;
            if (ex instanceof RegistryException) {
                log.error((Object)"RegistryException::", (Throwable)ex);
                RegistryException rex = (RegistryException)ex;
                faultCode = rex.getFaultCode();
                faultString = rex.getFaultString();
                faultActor = rex.getFaultActor();
                DispositionReport dispRpt = rex.getDispositionReport();
                if (dispRpt != null) {
                    Result result = null;
                    ErrInfo errInfo = null;
                    Vector results = dispRpt.getResultVector();
                    if (results != null && !results.isEmpty()) {
                        result = (Result)results.elementAt(0);
                    }
                    if (result != null) {
                        errno = String.valueOf(result.getErrno());
                        errInfo = result.getErrInfo();
                        if (errInfo != null) {
                            errCode = errInfo.getErrCode();
                            errMsg = errInfo.getErrMsg();
                        }
                    }
                }
            } else {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                faultCode = "Server";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode((int)10500);
                errMsg = Result.lookupErrText((int)10500);
            }
            try {
                SOAPBody soapResBody = soapRes.getSOAPBody();
                SOAPFault soapFault = soapResBody.addFault();
                if (faultCode == null) {
                    faultCode = "Unavailable";
                }
                if (!faultCode.contains(":")) {
                    faultCode = soapResBody.getPrefix() + ":" + faultCode;
                }
                soapFault.setFaultCode(faultCode);
                soapFault.setFaultString(faultString);
                soapFault.setFaultActor(faultActor);
                Detail faultDetail = soapFault.addDetail();
                SOAPElement dispRpt = faultDetail.addChildElement("dispositionReport", "", "urn:uddi-org:api_v2");
                dispRpt.setAttribute("generic", "2.0");
                dispRpt.setAttribute("operator", Config.getOperator());
                SOAPElement result = dispRpt.addChildElement("result");
                result.setAttribute("errno", errno);
                SOAPElement errInfo = result.addChildElement("errInfo");
                errInfo.setAttribute("errCode", errCode);
                errInfo.setValue(errMsg);
            }
            catch (Exception e) {
                log.error((Object)"A serious error has occured while assembling the SOAP Fault.", (Throwable)e);
            }
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    soapRes.writeTo((OutputStream)bs);
                    log.debug((Object)("Response being sent::" + bs.toString()));
                }
                soapRes.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException sex) {
                log.error((Object)"SOAPException::", (Throwable)sex);
            }
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            log.error((Object)"ParserConfigurationException::", (Throwable)pcex);
        }
        return docBuilder;
    }

    private SOAPMessage createSOAPMessage(Element elem) throws Exception {
        String prefix = "uddi";
        MessageFactory msgFactory = MessageFactory.newInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPMessage message = msgFactory.createMessage();
        message.getSOAPHeader().detachNode();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPBody soapBody = soapPart.getEnvelope().getBody();
        String uddins = "urn:uddi-org:api_v2";
        Name bodyName = factory.createName(elem.getNodeName(), prefix, uddins);
        SOAPBodyElement bodyElement = soapBody.addBodyElement(bodyName);
        bodyElement.addNamespaceDeclaration(prefix, uddins);
        this.appendAttributes((SOAPElement)bodyElement, elem.getAttributes(), factory);
        this.appendElements((SOAPElement)bodyElement, elem.getChildNodes(), factory);
        return message;
    }

    private void appendAttributes(SOAPElement bodyElement, NamedNodeMap nnm, SOAPFactory factory) throws SOAPException {
        int len = nnm != null ? nnm.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            Node n = nnm.item(i);
            String nodename = n.getNodeName();
            String nodevalue = n.getNodeValue();
            if ("xmlns".equals(nodename)) continue;
            if ("xml:lang".equals(nodename)) {
                Name xmlLang = factory.createName("lang", "xml", "");
                bodyElement.addAttribute(xmlLang, nodevalue);
                continue;
            }
            bodyElement.addAttribute(factory.createName(nodename), nodevalue);
        }
    }

    private void appendElements(SOAPElement bodyElement, NodeList nlist, SOAPFactory factory) throws SOAPException {
        String prefix = "uddi";
        String uddins = "urn:uddi-org:api_v2";
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            int nodeType;
            Node node = nlist.item(i);
            int n = nodeType = node != null ? (int)node.getNodeType() : -100;
            if (1 == nodeType) {
                Element el = (Element)node;
                Name name = factory.createName(el.getNodeName(), prefix, uddins);
                SOAPElement attachedEl = bodyElement.addChildElement(name);
                this.appendAttributes(attachedEl, el.getAttributes(), factory);
                this.appendElements(attachedEl, el.getChildNodes(), factory);
                continue;
            }
            if (nodeType != 3) continue;
            bodyElement.addTextNode(node.getNodeValue());
        }
    }
}

