/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelPackageVersionPK;
import org.rhq.core.domain.content.PackageVersion;

@Entity
@IdClass(value=ChannelPackageVersionPK.class)
@NamedQueries(value={@NamedQuery(name="ChannelPackageVersion.deleteByChannelId", query="DELETE ChannelPackageVersion cpv WHERE cpv.channel.id = :channelId")})
@Table(name="RHQ_CHANNEL_PKG_VERSION_MAP")
public class ChannelPackageVersion
implements Serializable {
    public static final String DELETE_BY_CHANNEL_ID = "ChannelPackageVersion.deleteByChannelId";
    private static final long serialVersionUID = 1L;
    @Id
    private Channel channel;
    @Id
    private PackageVersion packageVersion;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected ChannelPackageVersion() {
    }

    public ChannelPackageVersion(Channel channel, PackageVersion packageVersion) {
        this.channel = channel;
        this.packageVersion = packageVersion;
    }

    public ChannelPackageVersionPK getChannelPackageVersionPK() {
        return new ChannelPackageVersionPK(this.channel, this.packageVersion);
    }

    public void setChannelPackageVersionPK(ChannelPackageVersionPK pk) {
        this.channel = pk.getChannel();
        this.packageVersion = pk.getPackageVersion();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ChannelPV: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", ch=[").append(this.channel).append("]");
        str.append(", pv=[").append(this.packageVersion).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ChannelPackageVersion)) {
            return false;
        }
        ChannelPackageVersion other = (ChannelPackageVersion)obj;
        if (this.channel == null ? this.channel != null : !this.channel.equals(other.channel)) {
            return false;
        }
        return !(this.packageVersion == null ? this.packageVersion != null : !this.packageVersion.equals(other.packageVersion));
    }
}

