/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ExpiredEntryMonitor
extends Thread {
    private static boolean _started = false;
    private static Vector _expiryScanners = new Vector();
    private static int _scanIntervalSeconds = 43200;
    private static SimpleDateFormat _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static boolean notSkipping = true;
    private static ExpiredEntryMonitor _theInstance = null;

    public static boolean startUp() {
        block10: {
            if (_started) {
                return false;
            }
            String scanIntervalString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.expiryScanInterval");
            if (scanIntervalString != null) {
                try {
                    Integer scanIntervalInteger = new Integer(scanIntervalString);
                    _scanIntervalSeconds = scanIntervalInteger * 60 * 60;
                    if (tsLogger.arjLoggerI18N.debugAllowed()) {
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_1", new Object[]{Integer.toString(_scanIntervalSeconds)});
                    }
                }
                catch (NumberFormatException e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block10;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_11", new Object[]{"com.arjuna.ats.arjuna.recovery.expiryScanInterval", scanIntervalString});
                }
            }
        }
        if (_scanIntervalSeconds == 0) {
            if (tsLogger.arjLoggerI18N.debugAllowed()) {
                tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_2");
            }
            return false;
        }
        if (_scanIntervalSeconds < 0) {
            notSkipping = false;
            _scanIntervalSeconds = -_scanIntervalSeconds;
        }
        ExpiredEntryMonitor.loadScanners();
        if (_expiryScanners.size() == 0) {
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_3");
            }
            return false;
        }
        _theInstance = new ExpiredEntryMonitor();
        return _started;
    }

    public static void shutdown() {
        _started = false;
        _expiryScanners = new Vector();
        _scanIntervalSeconds = 43200;
        notSkipping = true;
        _theInstance.interrupt();
        _theInstance = null;
    }

    private ExpiredEntryMonitor() {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_4");
        }
        _started = true;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block8: {
            do {
                if (tsLogger.arjLogger.isInfoEnabled()) {
                    tsLogger.arjLogger.info("--- ExpiredEntryMonitor ----" + _theTimestamper.format(new Date()) + "----");
                }
                if (notSkipping) {
                    Enumeration scanners = _expiryScanners.elements();
                    while (scanners.hasMoreElements()) {
                        ExpiryScanner m = (ExpiryScanner)scanners.nextElement();
                        m.scan();
                        if (!tsLogger.arjLogger.isDebugEnabled()) continue;
                        tsLogger.arjLogger.debug(16L, 4L, 2048L, "  ");
                    }
                } else {
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_5");
                    }
                    notSkipping = true;
                }
                try {
                    Thread.sleep(_scanIntervalSeconds * 1000);
                }
                catch (InterruptedException e1) {
                    break block8;
                }
            } while (_started);
            return;
        }
    }

    private static void loadScanners() {
        Properties properties = arjPropertyManager.propertyManager.getProperties();
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String propertyName = (String)names.nextElement();
                if (!propertyName.startsWith("com.arjuna.ats.arjuna.recovery.expiryScanner")) continue;
                ExpiredEntryMonitor.loadScanner(properties.getProperty(propertyName));
            }
        }
    }

    private static void loadScanner(String className) {
        block15: {
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[]{className});
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_7");
                }
                return;
            }
            try {
                Class<?> c;
                block14: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        ExpiryScanner m = (ExpiryScanner)c.newInstance();
                        if (m.toBeUsed()) {
                            _expiryScanners.add(m);
                        } else if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                            tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_8", new Object[]{className});
                        }
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_9", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException e1) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[]{e1});
                        }
                    }
                    catch (InstantiationException e2) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block14;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[]{e2});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block15;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_10", new Object[]{className});
            }
        }
    }
}

