/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.jbosscache;

import java.io.IOException;
import java.io.InputStream;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.TemplateConfigurationHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoJBossCacheFactory<K, V> {
    public static final String JBOSSCACHE_CONFIG = "jbosscache-configuration";
    public static final String JGROUPS_CONFIG = "jgroups-configuration";
    public static final String JGROUPS_MUX_ENABLED = "jgroups-multiplexer-stack";
    private final TemplateConfigurationHelper configurationHelper;
    private final TransactionManager transactionManager;
    private ConfigurationManager configurationManager;
    private final Log log = ExoLogger.getLogger(ExoJBossCacheFactory.class);

    public ExoJBossCacheFactory(ConfigurationManager configurationManager, TransactionManager transactionManager) {
        this.configurationManager = configurationManager;
        this.configurationHelper = TemplateConfigurationHelper.createJBossCacheHelper(configurationManager);
        this.transactionManager = transactionManager;
    }

    public ExoJBossCacheFactory(ConfigurationManager configurationManager) {
        this(configurationManager, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache<K, V> createCache(MappedParametrizedObjectEntry parameterEntry) throws RepositoryConfigurationException {
        InputStream configStream;
        String jBossCacheConfigurationPath = parameterEntry.getParameterValue(JBOSSCACHE_CONFIG);
        this.log.info((Object)("JBoss Cache configuration used: " + jBossCacheConfigurationPath));
        try {
            configStream = this.configurationHelper.fillTemplate(jBossCacheConfigurationPath, parameterEntry.getParameters());
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        DefaultCacheFactory factory = new DefaultCacheFactory();
        Cache cache = factory.createCache(configStream, false);
        if (this.transactionManager != null) {
            cache.getConfiguration().getRuntimeConfig().setTransactionManager(this.transactionManager);
        }
        if (parameterEntry.getParameterBoolean(JGROUPS_MUX_ENABLED, false).booleanValue()) {
            try {
                String jgroupsConfigurationFilePath = parameterEntry.getParameterValue(JGROUPS_CONFIG);
                if (jgroupsConfigurationFilePath == null) return cache;
                JChannelFactory muxFactory = new JChannelFactory();
                muxFactory.setMultiplexerConfig(this.configurationManager.getResource(jgroupsConfigurationFilePath));
                cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory((ChannelFactory)muxFactory);
                this.log.info((Object)"Multiplexer stack successfully enabled for the cache.");
                return cache;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RepositoryConfigurationException("Error setting multiplexer configuration.", e);
            }
        }
        String jgroupsConfigurationFilePath = parameterEntry.getParameterValue(JGROUPS_CONFIG, null);
        if (jgroupsConfigurationFilePath == null) return cache;
        try {
            cache.getConfiguration().setJgroupsConfigFile(this.configurationManager.getResource(jgroupsConfigurationFilePath));
            this.log.info((Object)("Custom JGroups configuration set:" + this.configurationManager.getResource(jgroupsConfigurationFilePath)));
            return cache;
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Error setting JGroups configuration.", e);
        }
    }
}

