/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class AnyURIAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#anyURI";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#anyURI");
    private URI value;

    public AnyURIAttribute(URI value) {
        super(identifierURI);
        this.value = value;
    }

    public static AnyURIAttribute getInstance(Node root) throws URISyntaxException {
        return AnyURIAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static AnyURIAttribute getInstance(String value) throws URISyntaxException {
        return new AnyURIAttribute(new URI(value));
    }

    public URI getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnyURIAttribute)) {
            return false;
        }
        AnyURIAttribute other = (AnyURIAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "AnyURIAttribute: \"" + this.value.toString() + "\"";
    }

    public String encode() {
        return this.value.toString();
    }
}

