/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.util.Iterator;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.DebugLifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugLifecycleFactory
extends LifecycleFactory {
    private static final Log _log = LogFactory.getLog(DebugLifecycleFactory.class);
    private LifecycleFactory _defaultFactory;
    private DebugLifecycle _debugLifecycle;

    private DebugLifecycle getDebugLifecycle() {
        if (this._debugLifecycle == null) {
            this._debugLifecycle = new DebugLifecycle(this._defaultFactory.getLifecycle("DEFAULT"));
        }
        return this._debugLifecycle;
    }

    public DebugLifecycleFactory(LifecycleFactory defaultFactory) {
        this._defaultFactory = defaultFactory;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Created Lifecycle instance");
        }
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        this._defaultFactory.addLifecycle(lifecycleId, lifecycle);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Added lifecycle with ID " + lifecycleId));
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) {
        DebugLifecycle life = "DEBUG".equals(lifecycleId) ? this.getDebugLifecycle() : this._defaultFactory.getLifecycle(lifecycleId);
        return life;
    }

    public Iterator getLifecycleIds() {
        return this._defaultFactory.getLifecycleIds();
    }
}

