/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.ajax4jsf.application.ComponentsLoader;

public class ComponentsLoaderImpl
implements ComponentsLoader {
    private Map<String, Class<? extends UIComponent>> classes = new ConcurrentHashMap<String, Class<? extends UIComponent>>(64);
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public ComponentsLoaderImpl() {
        if (this.loader == null) {
            this.loader = ComponentsLoaderImpl.class.getClassLoader();
        }
    }

    public UIComponent createComponent(String type) {
        Class<? extends UIComponent> componentClass = this.classes.get(type);
        if (null == componentClass) {
            try {
                componentClass = this.loader.loadClass(type).asSubclass(UIComponent.class);
                this.classes.put(type, componentClass);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException("Can't load class " + type, (Throwable)e);
            }
        }
        try {
            return componentClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new FacesException("Error on create new instance of the component with class " + type, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException("IllegalAccess on attempt to create new instance of the component with class " + type, (Throwable)e);
        }
    }

    ClassLoader getClassLoader() {
        return this.loader;
    }
}

