/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content.composite;

import java.io.Serializable;

public class LoadedPackageBitsComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int packageVersionId;
    private final String fileName;
    private final Integer packageBitsId;
    private final boolean isPackageBitsInDatabase;

    public LoadedPackageBitsComposite(int packageVersionId, String fileName, Integer packageBitsId, boolean isPackageBitsInDatabase) {
        if (packageBitsId == null && isPackageBitsInDatabase) {
            throw new IllegalArgumentException("Does not make sense that there is no bits ID but bits are in DB");
        }
        this.packageVersionId = packageVersionId;
        this.fileName = fileName;
        this.packageBitsId = packageBitsId;
        this.isPackageBitsInDatabase = isPackageBitsInDatabase;
    }

    public LoadedPackageBitsComposite(int packageVersionId, String fileName, Number packageBitsId, Number isPackageBitsInDatabase) {
        this(packageVersionId, fileName, packageBitsId != null ? new Integer(packageBitsId.intValue()) : null, isPackageBitsInDatabase != null && isPackageBitsInDatabase.intValue() > 0);
    }

    public int getPackageVersionId() {
        return this.packageVersionId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getPackageBitsId() {
        return this.packageBitsId;
    }

    public boolean isPackageBitsAvailable() {
        return this.packageBitsId != null;
    }

    public boolean isPackageBitsInDatabase() {
        return this.isPackageBitsInDatabase;
    }
}

