/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.group.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="group")
@Entity
@NamedQueries(value={@NamedQuery(name="GroupOperationHistory.findActiveInProgress", query="SELECT h   FROM GroupOperationHistory h   WHERE h.status = :status   AND EXISTS       ( SELECT roh.id           FROM ResourceOperationHistory roh          WHERE roh.groupOperationHistory.id = h.id            AND roh.status = :status ) "), @NamedQuery(name="GroupOperationHistory.findAbandonedInProgress", query="SELECT h   FROM GroupOperationHistory h   WHERE h.status = :status   AND EXISTS       ( SELECT roh.id           FROM ResourceOperationHistory roh          WHERE roh.groupOperationHistory.id = h.id            AND roh.status <> :status ) "), @NamedQuery(name="GroupOperationHistory.findMemberlessInProgress", query="SELECT h   FROM GroupOperationHistory h   WHERE h.status = :status   AND NOT EXISTS       ( SELECT roh.id           FROM ResourceOperationHistory roh          WHERE roh.groupOperationHistory.id = h.id ) "), @NamedQuery(name="GroupOperationHistory.findByGroupIdAndStatus", query="select h from GroupOperationHistory h where h.group.id = :groupId and h.status = :status"), @NamedQuery(name="GroupOperationHistory.findByGroupIdAndNotStatus", query="select h from GroupOperationHistory h where h.group.id = :groupId and h.status <> :status")})
public class GroupOperationHistory
extends OperationHistory {
    public static final String QUERY_FIND_ACTIVE_IN_PROGRESS = "GroupOperationHistory.findActiveInProgress";
    public static final String QUERY_FIND_ABANDONED_IN_PROGRESS = "GroupOperationHistory.findAbandonedInProgress";
    public static final String QUERY_FIND_MEMBERLESS_IN_PROGRESS = "GroupOperationHistory.findMemberlessInProgress";
    public static final String QUERY_FIND_BY_GROUP_ID_AND_STATUS = "GroupOperationHistory.findByGroupIdAndStatus";
    public static final String QUERY_FIND_BY_GROUP_ID_AND_NOT_STATUS = "GroupOperationHistory.findByGroupIdAndNotStatus";
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="GROUP_ID", referencedColumnName="ID")
    @ManyToOne
    private ResourceGroup group;
    @OneToMany(mappedBy="groupOperationHistory", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ResourceOperationHistory> resourceOperationHistories = new ArrayList<ResourceOperationHistory>();

    protected GroupOperationHistory() {
    }

    public GroupOperationHistory(String jobName, String jobGroup, String subjectName, OperationDefinition operationDefinition, Configuration parameters, ResourceGroup group) {
        super(jobName, jobGroup, subjectName, operationDefinition, parameters);
        this.group = group;
        this.setStartedTime();
    }

    public ResourceGroup getGroup() {
        return this.group;
    }

    public void setGroup(ResourceGroup group) {
        this.group = group;
    }

    public List<ResourceOperationHistory> getResourceOperationHistories() {
        return this.resourceOperationHistories;
    }

    public void setResourceOperationHistories(List<ResourceOperationHistory> resourceOperationHistories) {
        this.resourceOperationHistories = resourceOperationHistories;
    }

    public void addResourceOperationHistory(ResourceOperationHistory history) {
        this.resourceOperationHistories.add(history);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("GroupOperationHistory: ");
        str.append("group=[" + this.group);
        str.append("], " + super.toString());
        str.append("]");
        return str.toString();
    }
}

