/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.util.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationElement
extends PortableAnnotationElement {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    public static <T extends Annotation> T getVisibleAnnotation(Method method, Class<T> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(method, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(method, annotation);
    }

    public static <T extends Annotation> T getVisibleAnnotation(Constructor<?> con, Class<T> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(con, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(con, annotation);
    }

    public static <T extends Annotation> T getVisibleAnnotation(Field field, Class<T> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(field, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(field, annotation);
    }

    public static <T extends Annotation> T getVisibleAnnotation(Class<?> clazz, Class<T> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(clazz, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(clazz, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Method m, Class<? extends Annotation> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Field f, Class<? extends Annotation> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Constructor<?> con, Class<? extends Annotation> annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Class<?> clazz, String annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Method m, String annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Field f, String annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Constructor<?> con, String annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
    }

    public static Annotation[] getVisibleAnnotations(Class<?> clazz) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(clazz);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(clazz);
    }

    public static Annotation[] getVisibleAnnotations(Method m) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(m);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(m);
    }

    public static Annotation[] getVisibleAnnotations(Field f) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(f);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(f);
    }

    public static Annotation[] getVisibleAnnotations(Constructor<?> c) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(c);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AnnotationElementAction {
        public static final AnnotationElementAction NON_PRIVILEGED = new AnnotationElementAction(){

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Method method, Class<T> annotation) {
                return method.getAnnotation(annotation);
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Constructor<?> con, Class<T> annotation) {
                return (T)con.getAnnotation(annotation);
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Field field, Class<T> annotation) {
                return field.getAnnotation(annotation);
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Class<?> clazz, Class<T> annotation) {
                return clazz.getAnnotation(annotation);
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Method method, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(method)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return (T)a;
                }
                return null;
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Constructor<?> con, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(con)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return (T)a;
                }
                return null;
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Field field, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(field)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return (T)a;
                }
                return null;
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(Class<?> clazz, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(clazz)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return (T)a;
                }
                return null;
            }

            @Override
            public boolean isVisibleAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
                return clazz.isAnnotationPresent(annotation);
            }

            @Override
            public boolean isVisibleAnnotationPresent(Method m, Class<? extends Annotation> annotation) {
                return m.isAnnotationPresent(annotation);
            }

            @Override
            public boolean isVisibleAnnotationPresent(Field f, Class<? extends Annotation> annotation) {
                return f.isAnnotationPresent(annotation);
            }

            @Override
            public boolean isVisibleAnnotationPresent(Constructor<?> con, Class<? extends Annotation> annotation) {
                return con.isAnnotationPresent(annotation);
            }

            @Override
            public boolean isVisibleAnnotationPresent(Class<?> clazz, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(clazz)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isVisibleAnnotationPresent(Method m, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(m)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isVisibleAnnotationPresent(Field f, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(f)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isVisibleAnnotationPresent(Constructor<?> con, String annotation) {
                for (Annotation a : this.getVisibleAnnotations(con)) {
                    if (!a.annotationType().getName().equals(annotation)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(Class<?> clazz) {
                return clazz.getAnnotations();
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(Method m) {
                if (m.getName().startsWith("access$") && !ReflectUtils.isNotAccessMethod(m)) {
                    return EMPTY_ANNOTATIONS;
                }
                return m.getAnnotations();
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(Field f) {
                return f.getAnnotations();
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(Constructor<?> c) {
                return c.getAnnotations();
            }
        };
        public static final AnnotationElementAction PRIVILEGED = new AnnotationElementAction(){

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Method method, final Class<T> annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        return method.getAnnotation(annotation);
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Constructor<?> con, final Class<T> annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        return con.getAnnotation(annotation);
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Field field, final Class<T> annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        return field.getAnnotation(annotation);
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Class<?> clazz, final Class<T> annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        return clazz.getAnnotation(annotation);
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Method method, final String annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        for (Annotation a : method.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return a;
                        }
                        return null;
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Constructor<?> con, final String annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        for (Annotation a : con.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return a;
                        }
                        return null;
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Field field, final String annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        for (Annotation a : field.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return a;
                        }
                        return null;
                    }
                }));
            }

            @Override
            public <T extends Annotation> T getVisibleAnnotation(final Class<?> clazz, final String annotation) {
                return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        for (Annotation a : clazz.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return a;
                        }
                        return null;
                    }
                }));
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Class<?> clazz, final Class<? extends Annotation> annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return clazz.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Method m, final Class<? extends Annotation> annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return m.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Field f, final Class<? extends Annotation> annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return f.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Constructor<?> con, final Class<? extends Annotation> annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return con.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Class<?> clazz, final String annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Annotation a : clazz.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Method m, final String annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Annotation a : m.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Field f, final String annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Annotation a : f.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public boolean isVisibleAnnotationPresent(final Constructor<?> con, final String annotation) {
                Boolean present = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Annotation a : con.getAnnotations()) {
                            if (!a.annotationType().getName().equals(annotation)) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                return present;
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(final Class<?> clazz) throws Exception {
                try {
                    return (Annotation[])AccessController.doPrivileged(new PrivilegedExceptionAction<T[]>(){

                        @Override
                        public T[] run() throws Exception {
                            return clazz.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(final Method m) throws Exception {
                try {
                    return (Annotation[])AccessController.doPrivileged(new PrivilegedExceptionAction<T[]>(){

                        @Override
                        public T[] run() throws Exception {
                            if (m.getName().startsWith("access$") && !ReflectUtils.isNotAccessMethod(m)) {
                                return EMPTY_ANNOTATIONS;
                            }
                            return m.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(final Field f) throws Exception {
                try {
                    return (Annotation[])AccessController.doPrivileged(new PrivilegedExceptionAction<T[]>(){

                        @Override
                        public T[] run() throws Exception {
                            return f.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            @Override
            public <T extends Annotation> T[] getVisibleAnnotations(final Constructor<?> c) throws Exception {
                try {
                    return (Annotation[])AccessController.doPrivileged(new PrivilegedExceptionAction<T[]>(){

                        @Override
                        public T[] run() throws Exception {
                            return c.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };

        public <T extends Annotation> T getVisibleAnnotation(Method var1, Class<T> var2);

        public <T extends Annotation> T getVisibleAnnotation(Constructor<?> var1, Class<T> var2);

        public <T extends Annotation> T getVisibleAnnotation(Field var1, Class<T> var2);

        public <T extends Annotation> T getVisibleAnnotation(Class<?> var1, Class<T> var2);

        public <T extends Annotation> T getVisibleAnnotation(Method var1, String var2);

        public <T extends Annotation> T getVisibleAnnotation(Constructor<?> var1, String var2);

        public <T extends Annotation> T getVisibleAnnotation(Field var1, String var2);

        public <T extends Annotation> T getVisibleAnnotation(Class<?> var1, String var2);

        public boolean isVisibleAnnotationPresent(Class<?> var1, Class<? extends Annotation> var2);

        public boolean isVisibleAnnotationPresent(Method var1, Class<? extends Annotation> var2);

        public boolean isVisibleAnnotationPresent(Field var1, Class<? extends Annotation> var2);

        public boolean isVisibleAnnotationPresent(Constructor<?> var1, Class<? extends Annotation> var2);

        public boolean isVisibleAnnotationPresent(Class<?> var1, String var2);

        public boolean isVisibleAnnotationPresent(Method var1, String var2);

        public boolean isVisibleAnnotationPresent(Field var1, String var2);

        public boolean isVisibleAnnotationPresent(Constructor<?> var1, String var2);

        public <T extends Annotation> T[] getVisibleAnnotations(Class<?> var1) throws Exception;

        public <T extends Annotation> T[] getVisibleAnnotations(Method var1) throws Exception;

        public <T extends Annotation> T[] getVisibleAnnotations(Field var1) throws Exception;

        public <T extends Annotation> T[] getVisibleAnnotations(Constructor<?> var1) throws Exception;
    }
}

