/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.TimerService;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GlobalTxEntityMap;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.ejb.plugins.EntityInstanceCacheMBean;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.util.propertyeditor.PropertyEditors;

public class EntityInstanceCache
extends AbstractInstanceCache
implements EntityCache,
EntityInstanceCacheMBean {
    private EntityContainer m_container;

    public void setContainer(Container c) {
        this.m_container = (EntityContainer)c;
    }

    public Object createCacheKey(Object id) {
        return id;
    }

    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        EnterpriseContext rtn = null;
        rtn = super.get(id);
        return rtn;
    }

    public void remove(String id) throws Exception {
        EntityMetaData metaData = (EntityMetaData)this.m_container.getBeanMetaData();
        String primKeyClass = metaData.getPrimaryKeyClass();
        Object key = PropertyEditors.convertValue((String)id, (String)primKeyClass);
        this.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        EntityInstanceCache entityInstanceCache = this;
        synchronized (entityInstanceCache) {
            this.m_container = null;
        }
        super.destroy();
    }

    protected Object getKey(EnterpriseContext ctx) {
        return ((EntityEnterpriseContext)ctx).getCacheKey();
    }

    protected void setKey(Object id, EnterpriseContext ctx) {
        ((EntityEnterpriseContext)ctx).setCacheKey(id);
        ctx.setId(id);
    }

    protected synchronized Container getContainer() {
        return this.m_container;
    }

    protected void passivate(EnterpriseContext ctx) throws RemoteException {
        this.removeTimerServiceIfAllCancelledOrExpired(ctx);
        this.m_container.getPersistenceManager().passivateEntity((EntityEnterpriseContext)ctx);
    }

    protected void activate(EnterpriseContext ctx) throws RemoteException {
        this.m_container.getPersistenceManager().activateEntity((EntityEnterpriseContext)ctx);
    }

    protected EnterpriseContext acquireContext() throws Exception {
        return this.m_container.getInstancePool().get();
    }

    protected void freeContext(EnterpriseContext ctx) {
        this.m_container.getInstancePool().free(ctx);
    }

    protected boolean canPassivate(EnterpriseContext ctx) {
        if (ctx.isLocked()) {
            return false;
        }
        if (ctx.getTransaction() != null) {
            return false;
        }
        Object key = ((EntityEnterpriseContext)ctx).getCacheKey();
        return this.m_container.getLockManager().canPassivate(key);
    }

    protected void unableToPassivateDueToCtxLock(EnterpriseContext ctx, boolean passivateAfterCommit) {
        EntityEnterpriseContext ectx = (EntityEnterpriseContext)ctx;
        ectx.setPassivateAfterCommit(passivateAfterCommit);
        ConfigurationMetaData config = this.m_container.getBeanMetaData().getContainerConfiguration();
        if (!config.isStoreNotFlushed() && ectx.hasTxSynchronization()) {
            ectx.setTxAssociation(GlobalTxEntityMap.PREVENT_SYNC);
        }
    }

    protected void removeTimerServiceIfAllCancelledOrExpired(EnterpriseContext ctx) {
        Object pKey;
        ObjectName containerId;
        EJBTimerService service;
        TimerService timerService;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Check whether all timers are cancelled or expired for this entity: " + ctx));
        }
        if ((timerService = (service = this.m_container.getTimerService()).getTimerService(containerId = this.m_container.getJmxName(), pKey = ctx.getId())) != null && timerService.getTimers().isEmpty()) {
            if (trace) {
                log.trace((Object)("No active timers available for " + containerId + " and primary key " + pKey));
            }
            service.removeTimerService(containerId, pKey);
        }
    }
}

