/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CompiledStatement;
import org.hsqldb.CompiledStatementExecutor;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Database;
import org.hsqldb.DatabaseCommandInterpreter;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.SessionInterface;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.User;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class Session
implements SessionInterface {
    private volatile boolean isAutoCommit;
    private volatile boolean isReadOnly;
    private volatile boolean isClosed;
    Database database;
    private User user;
    HsqlArrayList rowActionList;
    private boolean isNestedTransaction;
    private int nestedOldTransIndex;
    int isolationMode = 2;
    long actionTimestamp;
    long transactionTimestamp;
    private int currentMaxRows;
    private int sessionMaxRows;
    private Number lastIdentity = ValuePool.getInt(0);
    private final int sessionId;
    HashMappedList savepoints;
    private boolean script;
    private Tokenizer tokenizer;
    private Parser parser;
    static final Result emptyUpdateCount = new Result(1);
    private jdbcConnection intConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    private HsqlNameManager.HsqlName oldSchema;
    boolean isProcessingScript;
    boolean isProcessingLog;
    private IntKeyHashMap indexArrayMap;
    private IntKeyHashMap indexArrayKeepMap;
    private final long connectTime = System.currentTimeMillis();
    DatabaseCommandInterpreter dbCommandInterpreter;
    CompiledStatementExecutor compiledStatementExecutor;
    CompiledStatementManager compiledStatementManager;
    long currentDateTimeSCN;
    long currentMillis;
    Date currentDate;
    Time currentTime;
    Timestamp currentTimestamp;

    Session getSession() {
        return this;
    }

    Session(Database database, User user, boolean bl, boolean bl2, int n) {
        this.sessionId = n;
        this.database = database;
        this.user = user;
        this.rowActionList = new HsqlArrayList(true);
        this.savepoints = new HashMappedList(4);
        this.isAutoCommit = bl;
        this.isReadOnly = bl2;
        this.dbCommandInterpreter = new DatabaseCommandInterpreter(this);
        this.compiledStatementExecutor = new CompiledStatementExecutor(this);
        this.compiledStatementManager = database.compiledStatementManager;
        this.tokenizer = new Tokenizer();
        this.parser = new Parser(this, this.database, this.tokenizer);
        this.resetSchema();
    }

    void resetSchema() {
        HsqlNameManager.HsqlName hsqlName = this.user.getInitialSchema();
        this.currentSchema = hsqlName == null ? this.database.schemaManager.getDefaultSchemaHsqlName() : hsqlName;
    }

    public int getId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.isClosed) {
                return;
            }
            this.database.sessionManager.removeSession(this);
            this.rollback();
            try {
                this.database.logger.writeToLog(this, "DISCONNECT");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.clearIndexRoots();
            this.clearIndexRootsKeep();
            this.compiledStatementManager.removeSession(this.sessionId);
            this.database.closeIfLast();
            this.database = null;
            this.user = null;
            this.rowActionList = null;
            this.savepoints = null;
            this.intConnection = null;
            this.compiledStatementExecutor = null;
            this.compiledStatementManager = null;
            this.dbCommandInterpreter = null;
            this.lastIdentity = null;
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setIsolation(int n) throws HsqlException {
        this.isolationMode = n;
    }

    public int getIsolation() throws HsqlException {
        return this.isolationMode;
    }

    void setLastIdentity(Number number) {
        this.lastIdentity = number;
    }

    Number getLastIdentity() {
        return this.lastIdentity;
    }

    Database getDatabase() {
        return this.database;
    }

    String getUsername() {
        return this.user.getName();
    }

    public User getUser() {
        return this.user;
    }

    void setUser(User user) {
        this.user = user;
    }

    int getMaxRows() {
        return this.currentMaxRows;
    }

    int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    void setSQLMaxRows(int n) {
        this.currentMaxRows = this.sessionMaxRows = n;
    }

    void checkAdmin() throws HsqlException {
        this.user.checkAdmin();
    }

    void check(HsqlNameManager.HsqlName hsqlName, int n) throws HsqlException {
        this.user.check(hsqlName, n);
    }

    void check(String string) throws HsqlException {
        this.user.check(string);
    }

    void checkReadWrite() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(31);
        }
    }

    void checkDDLWrite() throws HsqlException {
        if (this.database.isFilesReadOnly() && !this.user.isSys()) {
            throw Trace.error(31);
        }
    }

    boolean addDeleteAction(Table table, Row row) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction transaction = new Transaction(true, table, row, this.actionTimestamp);
            this.rowActionList.add(transaction);
            this.database.txManager.addTransaction(this, transaction);
            return true;
        }
        table.removeRowFromStore(row);
        return false;
    }

    boolean addInsertAction(Table table, Row row) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction transaction = new Transaction(false, table, row, this.actionTimestamp);
            this.rowActionList.add(transaction);
            this.database.txManager.addTransaction(this, transaction);
            return true;
        }
        table.commitRowToStore(row);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (bl != this.isAutoCommit) {
                this.commit();
                this.isAutoCommit = bl;
                try {
                    this.database.logger.writeToLog(this, this.getAutoCommitStatement());
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    public void startPhasedTransaction() throws HsqlException {
    }

    public void prepareCommit() throws HsqlException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (!this.rowActionList.isEmpty()) {
                try {
                    this.database.logger.writeCommitStatement(this);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
            this.database.txManager.commit(this);
            this.clearIndexRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.rowActionList.size() != 0) {
                try {
                    this.database.logger.writeToLog(this, "ROLLBACK");
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
            this.database.txManager.rollback(this);
            this.clearIndexRoots();
        }
    }

    public void resetSession() throws HsqlException {
        throw new HsqlException("", "", 0);
    }

    void savepoint(String string) throws HsqlException {
        this.savepoints.remove(string);
        this.savepoints.add(string, ValuePool.getInt(this.rowActionList.size()));
        try {
            this.database.logger.writeToLog(this, "SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void rollbackToSavepoint(String string) throws HsqlException {
        if (this.isClosed) {
            return;
        }
        try {
            this.database.logger.writeToLog(this, "ROLLBACK TO SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.database.txManager.rollbackSavepoint(this, string);
    }

    void releaseSavepoint(String string) throws HsqlException {
        int n = this.savepoints.getIndex(string);
        Trace.check(n >= 0, 44, string);
        while (this.savepoints.size() > n) {
            this.savepoints.remove(this.savepoints.size() - 1);
        }
    }

    void beginNestedTransaction() throws HsqlException {
        if (this.isNestedTransaction) {
            Trace.doAssert(false, "beginNestedTransaction");
        }
        this.nestedOldTransIndex = this.rowActionList.size();
        this.isNestedTransaction = true;
        if (this.isAutoCommit) {
            try {
                this.database.logger.writeToLog(this, "SET AUTOCOMMIT FALSE");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    void endNestedTransaction(boolean bl) throws HsqlException {
        if (!this.isNestedTransaction) {
            Trace.doAssert(false, "endNestedTransaction");
        }
        if (bl) {
            this.database.txManager.rollbackTransactions(this, this.nestedOldTransIndex, true);
        }
        this.isNestedTransaction = false;
        if (this.isAutoCommit) {
            this.database.txManager.commit(this);
            try {
                this.database.logger.writeToLog(this, "SET AUTOCOMMIT TRUE");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    public void setReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.databaseReadOnly) {
            throw Trace.error(31);
        }
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    boolean isNestedTransaction() {
        return this.isNestedTransaction;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    void setScripting(boolean bl) {
        this.script = bl;
    }

    boolean getScripting() {
        return this.script;
    }

    public String getAutoCommitStatement() {
        return this.isAutoCommit ? "SET AUTOCOMMIT TRUE" : "SET AUTOCOMMIT FALSE";
    }

    jdbcConnection getInternalConnection() throws HsqlException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }

    boolean isAdmin() {
        return this.user.isAdmin();
    }

    long getConnectTime() {
        return this.connectTime;
    }

    int getTransactionSize() {
        return this.rowActionList.size();
    }

    boolean isAccessible(String string) throws HsqlException {
        return this.user.isAccessible(string);
    }

    boolean isAccessible(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        return this.user.isAccessible(hsqlName);
    }

    CompiledStatement sqlCompileStatement(String string) throws HsqlException {
        CompiledStatement compiledStatement;
        this.parser.reset(string);
        int n = 0;
        String string2 = this.tokenizer.getString();
        int n2 = Token.get(string2);
        switch (n2) {
            case 313: {
                n = this.parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                compiledStatement = this.parser.compileSelectStatement(n);
                break;
            }
            case 112: {
                compiledStatement = this.parser.compileInsertStatement();
                break;
            }
            case 222: {
                compiledStatement = this.parser.compileUpdateStatement();
                break;
            }
            case 62: {
                compiledStatement = this.parser.compileDeleteStatement();
                break;
            }
            case 23: {
                compiledStatement = this.parser.compileCallStatement();
                break;
            }
            default: {
                compiledStatement = new CompiledStatement(this.currentSchema);
            }
        }
        if (compiledStatement.type != 9) {
            while (this.tokenizer.getPosition() < this.tokenizer.getLength()) {
                string2 = this.tokenizer.getString();
                if (string2.length() == 0 || string2.equals(";")) continue;
                throw Trace.error(11, string2);
            }
        }
        compiledStatement.sql = string;
        return compiledStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result result) {
        try {
            if (this.isClosed) {
                Trace.check(false, 33, Trace.getMessage(222));
            }
        }
        catch (Throwable throwable) {
            return new Result(throwable, null);
        }
        Database database = this.database;
        synchronized (database) {
            int n = result.mode;
            if (this.sessionMaxRows == 0) {
                this.currentMaxRows = result.updateCount;
            }
            this.actionTimestamp = this.database.txManager.nextActionTimestamp();
            JavaSystem.gc();
            switch (n) {
                case 65548: {
                    Result result2 = this.sqlExecute(result);
                    result2 = this.performPostExecute(result2);
                    return result2;
                }
                case 9: {
                    Result result3 = this.sqlExecuteBatch(result);
                    result3 = this.performPostExecute(result3);
                    return result3;
                }
                case 65547: {
                    Result result4 = this.sqlExecuteDirectNoPreChecks(result.getMainString());
                    result4 = this.performPostExecute(result4);
                    return result4;
                }
                case 8: {
                    Result result5 = this.sqlExecuteBatchDirect(result);
                    result5 = this.performPostExecute(result5);
                    return result5;
                }
                case 65555: {
                    CompiledStatement compiledStatement;
                    try {
                        compiledStatement = this.compiledStatementManager.compile(this, result.getMainString());
                    }
                    catch (Throwable throwable) {
                        return new Result(throwable, result.getMainString());
                    }
                    Result result6 = compiledStatement.describeResult();
                    Result result7 = compiledStatement.describeParameters();
                    return Result.newPrepareResponse(compiledStatement.id, result6, result7);
                }
                case 65552: {
                    this.compiledStatementManager.freeStatement(result.getStatementID(), this.sessionId, false);
                    return emptyUpdateCount;
                }
                case 7: {
                    return this.getAttributes();
                }
                case 6: {
                    return this.setAttributes(result);
                }
                case 66541: {
                    switch (result.getEndTranType()) {
                        case 0: {
                            this.commit();
                            break;
                        }
                        case 1: {
                            this.rollback();
                            break;
                        }
                        case 4: {
                            try {
                                String string = result.getMainString();
                                this.releaseSavepoint(string);
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                        case 2: {
                            try {
                                this.rollbackToSavepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 66552: {
                    switch (result.getConnectionAttrType()) {
                        case 10027: {
                            try {
                                this.savepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 65545: {
                    this.close();
                    return emptyUpdateCount;
                }
            }
            return new Result(Trace.runtimeError(201, "Session.execute()"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result performPostExecute(Result result) {
        Result result2;
        try {
            try {
                if (this.database != null) {
                    this.database.schemaManager.logSequences(this, this.database.logger);
                    if (this.isAutoCommit) {
                        this.clearIndexRoots();
                        this.database.logger.synchLog();
                    }
                }
                result2 = result;
                Object var5_4 = null;
                if (this.database == null) return result2;
                if (!this.database.logger.needsCheckpoint()) return result2;
            }
            catch (Exception exception) {
                Result result3 = new Result(exception, null);
                Object var5_5 = null;
                if (this.database == null) return result3;
                if (!this.database.logger.needsCheckpoint()) return result3;
                try {
                    this.database.logger.checkpoint(false);
                    return result3;
                }
                catch (HsqlException hsqlException) {
                    this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
                }
                return result3;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.database == null) throw throwable;
            if (!this.database.logger.needsCheckpoint()) throw throwable;
            try {}
            catch (HsqlException hsqlException) {
                this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
                throw throwable;
            }
            this.database.logger.checkpoint(false);
            throw throwable;
        }
        try {}
        catch (HsqlException hsqlException) {
            this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "checkpoint did not complete");
            return result2;
        }
        this.database.logger.checkpoint(false);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result sqlExecuteDirectNoPreChecks(String string) {
        Database database = this.database;
        synchronized (database) {
            return this.dbCommandInterpreter.execute(string);
        }
    }

    Result sqlExecuteCompiledNoPreChecks(CompiledStatement compiledStatement, Object[] objectArray) {
        return this.compiledStatementExecutor.execute(compiledStatement, objectArray);
    }

    private Result sqlExecuteBatch(Result result) {
        int n = result.getStatementID();
        CompiledStatement compiledStatement = this.database.compiledStatementManager.getStatement(this, n);
        if (compiledStatement == null) {
            return new Result(Trace.runtimeError(203, null), null);
        }
        Expression[] expressionArray = compiledStatement.parameters;
        int n2 = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        while (record != null) {
            Object[] objectArray = record.data;
            Result result2 = this.sqlExecuteCompiledNoPreChecks(compiledStatement, objectArray);
            if (result2.mode == 1) {
                nArray[n2++] = result2.updateCount;
            } else if (result2.mode == 3) {
                nArray[n2++] = -2;
            } else {
                nArray = ArrayUtil.arraySlice(nArray, 0, n2);
                break;
            }
            record = record.next;
        }
        Result result3 = new Result(65548, nArray, 0);
        return result3;
    }

    private Result sqlExecuteBatchDirect(Result result) {
        int n = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        while (record != null) {
            Result result2;
            String string = (String)record.data[0];
            try {
                result2 = this.dbCommandInterpreter.execute(string);
            }
            catch (Throwable throwable) {
                result2 = new Result(2);
            }
            if (result2.mode == 1) {
                nArray[n++] = result2.updateCount;
            } else if (result2.mode == 3) {
                nArray[n++] = -2;
            } else {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                break;
            }
            record = record.next;
        }
        Result result3 = new Result(65548, nArray, 0);
        return result3;
    }

    private Result sqlExecute(Result result) {
        int n = result.getStatementID();
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(this, n);
        if (compiledStatement == null) {
            return new Result(Trace.runtimeError(203, null), null);
        }
        Object[] objectArray = result.getParameterData();
        return this.sqlExecute(compiledStatement, objectArray);
    }

    private Result sqlExecute(CompiledStatement compiledStatement, Object[] objectArray) {
        return this.sqlExecuteCompiledNoPreChecks(compiledStatement, objectArray);
    }

    Date getCurrentDate() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
            this.currentTime = null;
            this.currentTimestamp = null;
        } else if (this.currentDate == null) {
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
        }
        return this.currentDate;
    }

    Time getCurrentTime() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = new Time(HsqlDateTime.getNormalisedTime(this.currentMillis));
            this.currentTimestamp = null;
        } else if (this.currentTime == null) {
            this.currentTime = new Time(HsqlDateTime.getNormalisedTime(this.currentMillis));
        }
        return this.currentTime;
    }

    Timestamp getCurrentTimestamp() {
        if (this.currentDateTimeSCN != this.actionTimestamp) {
            this.currentDateTimeSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = null;
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        } else if (this.currentTimestamp == null) {
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        }
        return this.currentTimestamp;
    }

    Result getAttributes() {
        Result result = Result.newSessionAttributesResult();
        Object[] objectArray = new Object[]{this.database.getURI(), this.getUsername(), ValuePool.getInt(this.sessionId), ValuePool.getInt(this.isolationMode), ValuePool.getBoolean(this.isAutoCommit), ValuePool.getBoolean(this.database.databaseReadOnly), ValuePool.getBoolean(this.isReadOnly)};
        result.add(objectArray);
        return result;
    }

    Result setAttributes(Result result) {
        Object[] objectArray = result.rRoot.data;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            try {
                switch (i) {
                    case 4: {
                        this.setAutoCommit((Boolean)object);
                        break;
                    }
                    case 6: {
                        this.setReadOnly((Boolean)object);
                    }
                }
                continue;
            }
            catch (HsqlException hsqlException) {
                return new Result(hsqlException, null);
            }
        }
        return emptyUpdateCount;
    }

    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    boolean isSchemaDefintion() {
        return this.oldSchema != null;
    }

    void startSchemaDefinition(String string) throws HsqlException {
        if (this.isProcessingScript) {
            this.setSchema(string);
            return;
        }
        this.oldSchema = this.currentSchema;
        this.setSchema(string);
    }

    void endSchemaDefinition() throws HsqlException {
        if (this.oldSchema == null) {
            return;
        }
        this.currentSchema = this.oldSchema;
        this.oldSchema = null;
        this.database.logger.writeToLog(this, "SET SCHEMA " + this.currentSchema.statementName);
    }

    public void setSchema(String string) throws HsqlException {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(string);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String string) throws HsqlException {
        return string == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(string);
    }

    public String getSchemaName(String string) throws HsqlException {
        return string == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(string);
    }

    HsqlNameManager.HsqlName getSchemaHsqlNameForWrite(String string) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName = this.getSchemaHsqlName(string);
        if (this.database.schemaManager.isSystemSchema(hsqlName)) {
            throw Trace.error(227);
        }
        return hsqlName;
    }

    public String getSchemaNameForWrite(String string) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName = this.getSchemaHsqlNameForWrite(string);
        return hsqlName.name;
    }

    Node getIndexRoot(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        if (bl) {
            if (this.indexArrayKeepMap == null) {
                return null;
            }
            return (Node)this.indexArrayKeepMap.get(hsqlName.hashCode());
        }
        if (this.indexArrayMap == null) {
            return null;
        }
        return (Node)this.indexArrayMap.get(hsqlName.hashCode());
    }

    void setIndexRoot(HsqlNameManager.HsqlName hsqlName, boolean bl, Node node) {
        if (bl) {
            if (this.indexArrayKeepMap == null) {
                if (node == null) {
                    return;
                }
                this.indexArrayKeepMap = new IntKeyHashMap();
            }
            this.indexArrayKeepMap.put(hsqlName.hashCode(), node);
        } else {
            if (this.indexArrayMap == null) {
                if (node == null) {
                    return;
                }
                this.indexArrayMap = new IntKeyHashMap();
            }
            this.indexArrayMap.put(hsqlName.hashCode(), node);
        }
    }

    void dropIndex(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        if (bl) {
            if (this.indexArrayKeepMap != null) {
                this.indexArrayKeepMap.remove(hsqlName.hashCode());
            }
        } else if (this.indexArrayMap != null) {
            this.indexArrayMap.remove(hsqlName.hashCode());
        }
    }

    void clearIndexRoots() {
        if (this.indexArrayMap != null) {
            this.indexArrayMap.clear();
        }
    }

    void clearIndexRootsKeep() {
        if (this.indexArrayKeepMap != null) {
            this.indexArrayKeepMap.clear();
        }
    }
}

