/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.deployers;

import org.jboss.ha.framework.server.deployers.HAPartitionDependencyCreator;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.util.StringPropertyReplacer;

public class DefaultHAPartitionDependencyCreator
implements HAPartitionDependencyCreator {
    private static final Logger log = Logger.getLogger(DefaultHAPartitionDependencyCreator.class);
    public static final String DEFAULT_HA_PARTITION_DEPENDENCY_PREFIX = "partition:partitionName=";
    public static final DefaultHAPartitionDependencyCreator INSTANCE = new DefaultHAPartitionDependencyCreator();
    private final String prefix;

    public DefaultHAPartitionDependencyCreator() {
        this(DEFAULT_HA_PARTITION_DEPENDENCY_PREFIX);
    }

    public DefaultHAPartitionDependencyCreator(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        this.prefix = prefix;
    }

    public String getHAPartitionDependencyName(String partitionName) {
        return this.getHaPartitionDependencyPrefix() + DefaultHAPartitionDependencyCreator.getPropertyReplacedPartitionName(partitionName);
    }

    public String getHaPartitionDependencyPrefix() {
        return this.prefix == null ? DEFAULT_HA_PARTITION_DEPENDENCY_PREFIX : this.prefix;
    }

    private static String getPropertyReplacedPartitionName(String partitionName) {
        String value = partitionName;
        try {
            String replacedValue = StringPropertyReplacer.replaceProperties((String)value);
            if (value != replacedValue) {
                log.debug((Object)("Replacing " + ClusterConfigMetaData.class.getSimpleName() + " partitionName property " + value + " with " + replacedValue));
                value = replacedValue;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to replace partition name " + value), (Throwable)e);
        }
        return value;
    }
}

