/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeletePublisherAssertions;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DeletePublisherAssertionsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "delete_publisherAssertions";
    private HandlerMaker maker = null;

    protected DeletePublisherAssertionsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Vector nodeList = null;
        AbstractHandler handler = null;
        DeletePublisherAssertions obj = new DeletePublisherAssertions();
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")) != null && nodeList.size() == 1) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "publisherAssertion")) != null && nodeList.size() > 0) {
            handler = this.maker.lookup("publisherAssertion");
            for (int index = 0; index < nodeList.size(); ++index) {
                obj.addPublisherAssertion((PublisherAssertion)handler.unmarshal((Element)nodeList.elementAt(index)));
            }
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector keyVector;
        AuthInfo authInfo;
        DeletePublisherAssertions request = (DeletePublisherAssertions)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((authInfo = request.getAuthInfo()) != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((keyVector = request.getPublisherAssertionVector()) != null && keyVector.size() > 0) {
            handler = this.maker.lookup("publisherAssertion");
            for (int i = 0; i < keyVector.size(); ++i) {
                handler.marshal((PublisherAssertion)keyVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        PublisherAssertion assertion1 = new PublisherAssertion();
        assertion1.setFromKey("6f157513-844e-4a95-a856-d257e6ba0000");
        assertion1.setToKey("6f157513-844e-4a95-a856-d257e6ba1111");
        PublisherAssertion assertion2 = new PublisherAssertion();
        assertion2.setFromKey("6f157513-844e-4a95-a856-d257e6ba2222");
        assertion2.setToKey("6f157513-844e-4a95-a856-d257e6ba3333");
        DeletePublisherAssertions service = new DeletePublisherAssertions();
        service.setAuthInfo(authInfo);
        service.addPublisherAssertion(assertion1);
        service.addPublisherAssertion(assertion2);
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

