/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.connector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.remote.JMXProviderException;

public class ConnectorFactoryUtil {
    private ConnectorFactoryUtil() {
    }

    public static String normalizeProtocol(String protocol) {
        protocol = protocol.replace('+', '.');
        protocol = protocol.replace('-', '_');
        return protocol;
    }

    public static void validateEnvironmentMap(Map environment) {
        Set keys = environment.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            Object keyValue = null;
            try {
                keyValue = itr.next();
                String keyAsString = (String)keyValue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("All keys within environment map must be of type java.lang.String.  " + keyValue + " is of type " + keyValue.getClass().getName());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassLoader locateClassLoader(Map environment, String classLoaderKey) {
        ClassLoader classloader = null;
        Object val = environment.get(classLoaderKey);
        if (val != null) {
            if (!(val instanceof ClassLoader)) throw new IllegalArgumentException("Error using value specified for " + classLoaderKey + " because is not an instance of " + ClassLoader.class.getName());
            classloader = (ClassLoader)val;
        } else {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        environment.put(classLoaderKey, classloader);
        return classloader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List locateProviderPackage(Map environment, String providerPackageKey) throws JMXProviderException {
        String providerPackage = null;
        Object val = environment.get(providerPackageKey);
        if (providerPackage != null) {
            if (!(val instanceof String)) throw new JMXProviderException("Error processing " + providerPackageKey + " from the " + "environment map.  Is is not of type String.");
            providerPackage = ((String)val).trim();
            if (providerPackage.startsWith("|") || providerPackage.endsWith("|") || providerPackage.indexOf("||") != -1) {
                throw new JMXProviderException("Error processing " + providerPackageKey + " from the " + "environment map.  An empty provider package exists.");
            }
        } else {
            providerPackage = System.getProperty(providerPackageKey);
        }
        ArrayList<Object> providerPackages = new ArrayList<Object>();
        if (providerPackage == null || providerPackage.length() <= 0) return providerPackages;
        StringTokenizer tokenizer = new StringTokenizer(providerPackage, "|");
        while (tokenizer.hasMoreElements()) {
            providerPackages.add(tokenizer.nextElement());
        }
        return providerPackages;
    }
}

