/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.jboss.managed.api.ManagedProperty;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedComponent
implements ProfileServiceComponent<ProfileServiceComponent>,
ConfigurationFacet {
    private ResourceContext<ProfileServiceComponent> resourceContext;
    private String resourceDescription;

    public void start(ResourceContext<ProfileServiceComponent> resourceContext) throws Exception {
        this.resourceContext = resourceContext;
        this.resourceDescription = this.resourceContext.getResourceType() + " Resource with key [" + this.resourceContext.getResourceKey() + "]";
    }

    public void stop() {
    }

    public Configuration loadResourceConfiguration() {
        Configuration resourceConfig;
        try {
            Map<String, ManagedProperty> managedProperties = this.getManagedProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(this.resourceContext.getPluginConfiguration());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("*** AFTER LOAD:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            resourceConfig = ConversionUtils.convertManagedObjectToConfiguration(managedProperties, customProps, this.resourceContext.getResourceType());
        }
        catch (Exception e) {
            this.getLog().error((Object)("Failed to load configuration for " + this.resourceDescription + "."), (Throwable)e);
            throw new RuntimeException(ThrowableUtil.getAllMessages((Throwable)e));
        }
        return resourceConfig;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        Configuration resourceConfig = configurationUpdateReport.getConfiguration();
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        try {
            Map<String, ManagedProperty> managedProperties = this.getManagedProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(pluginConfig);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("*** BEFORE UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, this.resourceContext.getResourceType(), customProps);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("*** AFTER UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            this.updateComponent();
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Failed to update configuration for " + this.resourceDescription + "."), (Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
        }
    }

    protected abstract Map<String, ManagedProperty> getManagedProperties() throws Exception;

    protected abstract void updateComponent() throws Exception;

    protected abstract Log getLog();

    protected ResourceContext<ProfileServiceComponent> getResourceContext() {
        return this.resourceContext;
    }

    @Override
    public ProfileServiceConnection getConnection() {
        return ((ProfileServiceComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    protected String getResourceDescription() {
        return this.resourceDescription;
    }
}

